#!/bin/sh

SPSYSVERSION="1.1.5"
LIBVERSION="2.4.3"
SPDATE="25 November 1998"

SSI="$HOME"/.spider

echo "Spider Sysinfo Creator "$SPSYSVERSION" Freeware (c) 1998 Stephan Trebs"
echo

if test -z "$1" || test ! -z "$3"; then

 echo Usage: spidersys [option] file
 echo
 echo Options:
 echo \ \ -s, --safe\ \ \ \ \ \ Disable Software modul 
 echo \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \(Use this if you have problems creating a sysinfo\)
 echo \ \ -v, --version\ \ \ Display version information
 echo

else


 ARGVERSION="false"
 ARGSAVE="false"
 TOSAVE=spidersys.spd

 if test "$1" = "-v" || test "$1" = "--version"; then
  ARGVERSION="true"
 else
  if test "$1" = "-s" || test "$1" = "--safe"; then
   ARGSAVE="true"
   if test ! -z "$2"; then 
    TOSAVE="$2"
   fi
  else
   if test ! -z "$1"; then 
    TOSAVE="$1"
   fi
  fi
 fi

if test "$ARGVERSION" = "true";then
    echo Version: "$SPSYSVERSION"
    echo Date \ \ : "$SPDATE"
    echo Library: "$LIBVERSION"
    echo
    exit
fi
 
if test -d /usr/lib/spider; then
  SPATH=/usr/lib/spider
fi

if test -z "$SPATH"; then
 SPATH=$SPIDERPATH
fi

 # Wenn Library-Pfad nicht gefunden
 if test -z "$SPATH"; then
  echo "Can't find spider libraries, please set your SPIDERPATH"
  echo
  exit
 else

  "$SPATH"/scripts/prog/prexec.com  2> /dev/null

  if test "$ARGSAVE" = "true"; then
  "$SPATH"/scripts/sysinfo/make.com 2> ~/.spider/sperrors    
  else
   "$SPATH"/scripts/sysinfo/make.com -v 2> ~/.spider/sperrors  
  fi

  echo  "spidersys"		>  "$SSI"/file/creator.dat
  echo  "$SPSYSVERSION"		>> "$SSI"/file/creator.dat
  echo  "$LIBVERSION" 		>> "$SSI"/file/creator.dat  
  
    
  "$SPATH"/scripts/sysinfo/pack.com  2> /dev/null
  cp ~/.spider.tmp "$TOSAVE"
  "$SPATH"/scripts/prog/rmtemp.com 2> /dev/null
 fi

fi

