#!/bin/sh

SPBUGVERSION="1.0.3"
LIBVERSION="2.4.3"
SPDATE="25 November 1998"


SSI="$HOME"/.spider

echo "Spider Buginfo Creator "$SPBUGVERSION" Freeware (c) 1998 Stephan Trebs"
echo

if test -z "$1" || test ! -z "$2"; then

 echo Usage: spiderbug file
 echo
 echo Options:
 echo \ \ -v, --version\ \ \ Display version information
 echo

else

 ARGVERSION="false"
 TOSAVE=spiderbug.spd

 if test "$1" = "-v" || test "$1" = "--version"; then
  ARGVERSION="true"
 else
    TOSAVE="$1"
 fi

 
if test "$ARGVERSION" = "true";then
    echo Version: "$SPBUGVERSION"
    echo Date \ \ : "$SPDATE"
    echo Library: "$LIBVERSION"    
    echo
    exit
fi
 
if test -d /usr/lib/spider; then
  SPATH=/usr/lib/spider
fi

if test -z "$SPATH"; then
 SPATH="$SPIDERPATH"
fi

 # Wenn Library-Pfad nicht gefunden
 if test -z "$SPATH"; then
  echo "Can't find spider libraries, please set your SPIDERPATH"
  echo
  exit

 else

  if test -d "$SSI"; then
 
   echo  "spiderbug"		>  "$SSI"/file/creator.dat
   echo  "$SPBUGVERSION"	>> "$SSI"/file/creator.dat
   echo  "$LIBVERSION" 		>> "$SSI"/file/creator.dat

   
   # Gecrashte Temps sichern
   if test -s ~/.spider.tmp; then
    cp ~/.spider.tmp "$SSI"
   fi
    
   "$SPATH"/scripts/sysinfo/pack.com  2> /dev/null
   cp ~/.spider.tmp "$TOSAVE"
   "$SPATH"/scripts/prog/rmtemp.com 2> /dev/null
  else
   echo "Can't find a crashed sysinfo session"
   echo
   exit
  fi
 fi

fi

