#! /bin/csh

set SPSYSVERSION="1.1.5"
set LIBVERSION="2.4.3"
set SPDATE="27 November 1998"

set SPATH=""

set SSI="$HOME"/.spider

echo "Spider Sysinfo Creator "$SPSYSVERSION" Freeware (c) 1998 Stephan Trebs\n"


if (  $1 == "" || $3 != ""  ) then

 echo "Usage: spidersys [option] file\n"
 echo Options:
 echo \ \ -s, --safe\ \ \ \ \ \ Disable Software modul 
 echo \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \(Use this if you have problems creating a sysinfo\)
 echo "  -v, --version   Display version information\n"

else


set  ARGVERSION="false"
set  ARGSAVE="false"
set  TOSAVE=spidersys.spd

 if (  "$1" == "-v"  ||  "$1" == "--version"  ) then
 set   ARGVERSION="true"
 else
  if (  "$1" == "-s"  || "$1" == "--safe" ) then
    set ARGSAVE="true"
   if ( "$2" != "" ) then 
    set TOSAVE="$2"
   endif
  else
   if (  "$1"  != "" ) then 
    set TOSAVE="$1"
   endif
  endif
 endif

if (  "$ARGVERSION" == "true"  ) then
    echo Version: "$SPSYSVERSION"
    echo Date \ \ : "$SPDATE"
    echo Library: "$LIBVERSION\n"
    exit
endif

if ( -d /usr/lib/spider ) then
 set SPATH = /usr/lib/spider
endif

if (  "$SPATH" == ""  ) then
 set SPATH = $SPIDERPATH
endif


 # Wenn Library-Pfad nicht gefunden
 if (  "$SPATH" == "" ) then
  echo "Can't find spider libraries, please set your SPIDERPATH\n"
  exit
 else

  "$SPATH"/scripts/prog/prexec.com  >& /dev/null

  if (  "$ARGSAVE" == "true" ) then
  "$SPATH"/scripts/sysinfo/make.com >& ~/.spider/sperrors    
  else
   "$SPATH"/scripts/sysinfo/make.com -v >& ~/.spider/sperrors  
  endif

  echo  "spidersys"		>  "$SSI"/file/creator.dat
  echo  "$SPSYSVERSION"		>> "$SSI"/file/creator.dat
  echo  "$LIBVERSION" 		>> "$SSI"/file/creator.dat  
  
    
  "$SPATH"/scripts/sysinfo/pack.com >& /dev/null
  cp ~/.spider.tmp "$TOSAVE"
  "$SPATH"/scripts/prog/rmtemp.com >& /dev/null
 endif

endif

