#! /bin/csh

set SPBUGVERSION="1.0.3"
set LIBVERSION="2.4.3"
set SPDATE="25 November 1998"

set SPATH=""

set SSI="$HOME"/.spider

echo "Spider Buginfo Creator "$SPBUGVERSION" Freeware (c) 1998 Stephan Trebs\n"

if ( "$1" == ""  || "$2" != ""  ) then

 echo "Usage: spiderbug file\n"
 echo Options:
 echo \ \ -v, --version\ \ \ "Display version information\n"

else

 set  ARGVERSION="false"
 set  TOSAVE=spiderbug.spd

 if (  "$1" == "-v"  || "$1" == "--version"  ) then
  set   ARGVERSION="true"
 else
  set     TOSAVE="$1"
 endif

 
 if (  "$ARGVERSION" == "true" ) then
  echo Version: "$SPBUGVERSION"
  echo Date \ \ : "$SPDATE"
  echo Library: "$LIBVERSION\n"    
  exit
 endif
 
 if (  -d /usr/lib/spider ) then
  set   SPATH=/usr/lib/spider
 endif

 if ( "$SPATH" == "" ) then
  set  SPATH="$SPIDERPATH"
 endif

 # Wenn Library-Pfad nicht gefunden
 if (  "$SPATH" == "" ) then
  echo "Can't find spider libraries, please set your SPIDERPATH\n"
  exit
 else

  if (  -d "$SSI" ) then
   echo  "spiderbug"		>  "$SSI"/file/creator.dat
   echo  "$SPBUGVERSION"	>> "$SSI"/file/creator.dat
   echo  "$LIBVERSION" 		>> "$SSI"/file/creator.dat
   
   # Gecrashte Temps sichern
   if ( -s ~/.spider.tmp ) then
    cp ~/.spider.tmp "$SSI"
   endif
    
   "$SPATH"/scripts/sysinfo/pack.com  >& /dev/null
   cp ~/.spider.tmp "$TOSAVE"
   "$SPATH"/scripts/prog/rmtemp.com >& /dev/null
  else
   echo "Can't find a crashed sysinfo session\n"
   exit
  endif
 endif

endif

