#! /bin/sh 

#
# Copy system information
#

SPIDERVERSION="2.4.3"
LIBVERSION="2.4.3"


###########################################################
##
##  V O R B E H A N D L U N G
##
###########################################################

SSI="$HOME"/.spider
PKERNEL=/proc/sys/kernel


if test -d "$SSI"/tmp; then
  rm -R "$SSI"/tmp
fi


###########################################################
##
##   K O M M A N D O S
##
###########################################################

spidersm -r


df 			> "$SSI"/commands/df	 	# Partitionsgroesse
df -k 			> "$SSI"/commands/df_k 		# Partitionsgroesse
df -i 			> "$SSI"/commands/df_i 		# Partitionsgroesse
dmesg 			> "$SSI"/commands/dmesg		# Bootup-Meldung
finger 			> "$SSI"/commands/finger
finger -l		> "$SSI"/commands/finger_l
finger "$LOGNAME" 	> "$SSI"/commands/fingerx
free 			> "$SSI"/commands/free
ftpcount 		> "$SSI"/commands/ftpcount
ftpwho 			> "$SSI"/commands/ftpwho
groups 			> "$SSI"/commands/groups
hostname -f 		> "$SSI"/commands/hostname_f
id 	 		> "$SSI"/commands/id		# SunOS komp
id -g -r 		> "$SSI"/commands/id_gr		# Ultrix komp
id -g -n 		> "$SSI"/commands/id_gn		# Ultrix komp
id -G -r 		> "$SSI"/commands/id_Gr
id -G -n 		> "$SSI"/commands/id_Gn
id -u -r 		> "$SSI"/commands/id_ur
id -u -n 		> "$SSI"/commands/id_un
mount 			> "$SSI"/commands/mount
ps  m p a x w S c 	> "$SSI"/commands/ps
quota -v		> "$SSI"/commands/quota		# Quotas
uptime 			> "$SSI"/commands/uptime
w 			> "$SSI"/commands/w
w -s 			> "$SSI"/commands/w_s
who -u 			> "$SSI"/commands/who
who 			> "$SSI"/commands/who_		# Ultrix komp

X -showconfig 		2> "$SSI"/commands/Xshow	# X-Windows Config

# Does this work?
#X -probeonly 		2> "$SSI"/commands/Xprobe 	# X-Windows Config


###########################################################
##
##   C P ,   C A T   U N D   S H E L L B E F E H L E
##
###########################################################

ls -p -C -1 /lib 		>  "$SSI"/commands/libs
ls -p -C -1 /usr/lib 		>> "$SSI"/commands/libs
ls -p -C -1 /usr/openwin/lib 	>> "$SSI"/commands/libs
ls -p -C -1 /usr/local/lib 	>> "$SSI"/commands/libs

if test -d /usr/X11/lib; then
 ls -p -C -1 /usr/X11/lib 	>> "$SSI"/commands/libs
 ls -p -C -1 /usr/X11/lib	>> "$SSI"/commands/libs
fi 

if test -d /dev; then
 cat /dev/sndstat	> "$SSI"/dev/sndstat
fi

env 	> "$SSI"/commands/env
set 	> "$SSI"/commands/set	 

echo "$GROUPS"	> "$SSI"/commands/shGROUPS

# Nur erste 70 Zeilen, Rest sind Error Reports
head -n 70 ~/.X.err 	> "$SSI"/home/X.err

###########################################################
##
##   S O F T W A R E   M O D U L
##
###########################################################

if test "$1" = "-v"; then

 as		--version > "$SSI"/commands/progs/as
 autoconf  	--version > "$SSI"/commands/progs/autoconf 
 automake  	--version > "$SSI"/commands/progs/automake
 awk		--version > "$SSI"/commands/progs/awk
 bash     	--version > "$SSI"/commands/progs/bash
 bc	  	--version > "$SSI"/commands/progs/bc 
 bison     	--version > "$SSI"/commands/progs/bison
 cpio	  	--version > "$SSI"/commands/progs/cpio
 cvs	  	--version > "$SSI"/commands/progs/cvs 
 dmp	  	--version > "$SSI"/commands/progs/dmp
 elvis    	--version > "$SSI"/commands/progs/elvis 
 emacs     	--version > "$SSI"/commands/progs/emacs 
 fetchmail 	--version > "$SSI"/commands/progs/fetchmail 
 find     	--version > "$SSI"/commands/progs/find
 flex     	--version > "$SSI"/commands/progs/flex
 g77     	--version > "$SSI"/commands/progs/g77  
 gasp	 	--version > "$SSI"/commands/progs/gasp 
 gawk     	--version > "$SSI"/commands/progs/gawk
 gcc      	--version > "$SSI"/commands/progs/gcc
 gdb      	--version > "$SSI"/commands/progs/gdb 
 gettext  	--version > "$SSI"/commands/progs/gettext 
 gs       	--version > "$SSI"/commands/progs/gs
 indent   	--version > "$SSI"/commands/progs/indent
 info	 	--version > "$SSI"/commands/progs/info
 irc	 	--version > "$SSI"/commands/progs/irc
 ld	  	--version > "$SSI"/commands/progs/ld
 locate   	--version > "$SSI"/commands/progs/locate 
 m4       	--version > "$SSI"/commands/progs/m4 
 make     	--version > "$SSI"/commands/progs/make
 marc     	--version > "$SSI"/commands/progs/marc 
 mount   	--version > "$SSI"/commands/progs/mount
 mt		--version > "$SSI"/commands/progs/mt
 nm	  	--version > "$SSI"/commands/progs/nm 
 recode		--version > "$SSI"/commands/progs/recode
 rman		--version > "$SSI"/commands/progs/rman 
 rplay    	--version > "$SSI"/commands/progs/rplay 
 rpm      	--version > "$SSI"/commands/progs/rpm
 slrn     	--version > "$SSI"/commands/progs/slrn 
 strip 		--version > "$SSI"/commands/progs/strip
 tar      	--version > "$SSI"/commands/progs/tar
 texi2dvi	--version > "$SSI"/commands/progs/texi2dvi
 texindex	--version > "$SSI"/commands/progs/texindex 
 updatedb 	--version > "$SSI"/commands/progs/updatedb
 whatis 	--version > "$SSI"/commands/progs/whatis  


 gzip 		--version 2> "$SSI"/commands/progs/gzip  
 less 		--version 2> "$SSI"/commands/progs/less 
 
 xemacs 	--version > "$SSI"/commands/progs/xemacs 
 if test ! -s "$SSI"/commands/progs/xemacs; then
  xemacs 	--version 2> "$SSI"/commands/progs/xemacs 
 fi
 
 elm      	-v > "$SSI"/commands/progs/elm
 file    	-v > "$SSI"/commands/progs/file 
 fortune  	-v > "$SSI"/commands/progs/fortune 
 gpm      	-v > "$SSI"/commands/progs/gpm 
 ispell   	-v > "$SSI"/commands/progs/ispell
 ldd      	-v > "$SSI"/commands/progs/ldd 
 muscan   	-v > "$SSI"/commands/progs/muscan 
 mutt     	-v > "$SSI"/commands/progs/mutt 
 perl     	-v > "$SSI"/commands/progs/perl   
 procinfo 	-v > "$SSI"/commands/progs/procin  
 rup 		-v > "$SSI"/commands/progs/rup
 screen   	-v > "$SSI"/commands/progs/screen 
 spider   	-v > "$SSI"/commands/progs/spider
 spiderbug 	-v > "$SSI"/commands/progs/spiderbug
 spidersm 	-v > "$SSI"/commands/progs/spidersm
 spidersys 	-v > "$SSI"/commands/progs/spidersys
 
 man   		-V > "$SSI"/commands/progs/man 
 mcopy 		-V > "$SSI"/commands/progs/mtools
 quota 		-V > "$SSI"/commands/progs/quota 
 rdist 		-V > "$SSI"/commands/progs/rdist 
 sudo  		-V > "$SSI"/commands/progs/sudo 
 w     		-V > "$SSI"/commands/progs/procps

 
 at 		-V 2> "$SSI"/commands/progs/at 
 grep 		-V 2> "$SSI"/commands/progs/grep
 

 arc		> "$SSI"/commands/progs/arc 
 pkgmake 	> "$SSI"/commands/progs/pkgmake 
 rar     	> "$SSI"/commands/progs/rar

     
 lynx  		-version > "$SSI"/commands/progs/lynx

  
 archie 	-v 2> "$SSI"/commands/progs/archie

 
 zip 		-h > "$SSI"/commands/progs/zip

 
 tcsh		-c 'echo $version' > "$SSI"/commands/progs/tcsh
 

 # Unterschiedliche Linux-Versionen  
     ar  	--version > "$SSI"/commands/progs/ar  
 if test ! -s "$SSI"/commands/progs/ar; then
     ar		-V > "$SSI"/commands/progs/ar
 fi


 # Linux >	HP-UX 2> 
     sed 	--version > "$SSI"/commands/progs/sed 
 if test ! -s "$SSI"/commands/progs/sed; then
     sed 	--version 2> "$SSI"/commands/progs/sed  
 fi
 
 
 ####################################  
 for i in "$SSI"/commands/progs/*; do
  if  test ! -s "$i"; then
    rm "$i"
  fi
 done;

 ############################################   
 # D I S A B L E D
 #
 # HP-UX
 #
 # yes      --version > "$SSI"/commands/progs/sh-utils
 # wc       --version > "$SSI"/commands/progs/textutils
 # ls       --version > "$SSI"/commands/progs/fileutils
 # uudecode --version > "$SSI"/commands/progs/sharutils
 # diff     --version > "$SSI"/commands/progs/diffutils
 # ld       -v > "$SSI"/commands/progs/binutils    
 #
 #
 # Ultrix
 #
 # ed  		--version > "$SSI"/commands/progs/ed  
 ############################################# 
 
fi 

###########################################################
##
##   P R O C   F I L E S Y S T E M
##
###########################################################

if test -d /proc; then

 cat /proc/apm 		> "$SSI"/proc/apm 
 cat /proc/cmdline 	> "$SSI"/proc/cmdline 
 cat /proc/cpuinfo 	> "$SSI"/proc/cpuinfo	
 cat /proc/devices 	> "$SSI"/proc/devices 
 cat /proc/dma 		> "$SSI"/proc/dma
 cat /proc/filesystems 	> "$SSI"/proc/filesystems
 cat /proc/interrupts 	> "$SSI"/proc/interrupts
 cat /proc/ioports 	> "$SSI"/proc/ioports 
 cat /proc/ksyms 	> "$SSI"/proc/ksyms
 cat /proc/loadavg 	> "$SSI"/proc/loadavg
 cat /proc/locks 	> "$SSI"/proc/locks 
 cat /proc/mdstat 	> "$SSI"/proc/mdstat
 cat /proc/meminfo 	> "$SSI"/proc/meminfo	 
 cat /proc/memstat 	> "$SSI"/proc/memstat 
 cat /proc/misc 	> "$SSI"/proc/misc 
 cat /proc/modules 	> "$SSI"/proc/modules 
 cat /proc/mounts 	> "$SSI"/proc/mounts 
 cat /proc/pci		> "$SSI"/proc/pci	
 cat /proc/rtc 		> "$SSI"/proc/rtc
 cat /proc/stat 	> "$SSI"/proc/stat 
 cat /proc/uptime 	> "$SSI"/proc/uptime
 cat /proc/version	> "$SSI"/proc/version
 
  
 cat /proc/net/alias_types	> "$SSI"/proc/net/alias_types
 cat /proc/net/aliases		> "$SSI"/proc/net/aliases
 cat /proc/net/arp 		> "$SSI"/proc/net/arp
 cat /proc/net/bpqether		> "$SSI"/proc/net/bpqether
 cat /proc/net/dev 		> "$SSI"/proc/net/dev
 cat /proc/net/igmp 		> "$SSI"/proc/net/igmp
 cat /proc/net/route 		> "$SSI"/proc/net/route
 cat /proc/net/rt_cache		> "$SSI"/proc/net/rt_cache
 cat /proc/net/snmp 		> "$SSI"/proc/net/snmp
 cat /proc/net/sockstat		> "$SSI"/proc/net/sockstat
 cat /proc/net/tcp 		> "$SSI"/proc/net/tcp
 cat /proc/net/udp 		> "$SSI"/proc/net/udp
 cat /proc/net/unix 		> "$SSI"/proc/net/unix
 cat /proc/net/wireless 	> "$SSI"/proc/net/wireless

 if test -e /proc/scsi/scsi; then
  cat /proc/scsi/scsi 		> "$SSI"/proc/scsi/scsi
  cat /proc/scsi/ide-scsi/0 	> "$SSI"/proc/scsi/ide-scsi/0 
  cat /proc/scsi/tmscsiw/0	> "$SSI"/proc/scsi/tmscsiw/0
 fi

 
 cat /proc/sys/kernel/file-max 	> "$SSI"/proc/sys/kernel/file-max 
 cat /proc/sys/kernel/file-nr 	> "$SSI"/proc/sys/kernel/file-nr
 cat /proc/sys/kernel/inode-max > "$SSI"/proc/sys/kernel/inode-max 
 cat /proc/sys/kernel/inode-nr 	> "$SSI"/proc/sys/kernel/inode-nr
 cat /proc/sys/kernel/panic 	> "$SSI"/proc/sys/kernel/panic 
 cat /proc/sys/kernel/version 	> "$SSI"/proc/sys/kernel/version

 
 cat "$PKERNEL"/hostname 	> "$SSI"$PKERNEL/hostname  
 cat "$PKERNEL"/osrelease	> "$SSI"$PKERNEL/osrelease	
 cat "$PKERNEL"/ostype 		> "$SSI""$PKERNEL"/ostype	

 ##########################
 for i in "$SSI"/proc/*; do
  if  test ! -s "$i"; then
    rm "$i"
  fi
 done;
 
fi

###########################################################
##
##   E T C   D I R E C T O R Y
##
###########################################################

if test -d /etc; then
 cp /etc/HOSTNAME	"$SSI"/etc/HOSTNAME
 cp /etc/copyright 	"$SSI"/etc/copyright		# Copyright-Info (HP-UX)
 cp /etc/copyright.orig	"$SSI"/etc/copyright.orig	# Copyright-Info (HP-UX)
 cp /etc/exports	"$SSI"/etc/exports
 cp /etc/fstab 		"$SSI"/etc/fstab		# Partitionen
 cp /etc/hosts 		"$SSI"/etc/hosts		# IPs
 cp /etc/inittab	"$SSI"/etc/inittab
 cp /etc/isapnp.conf	"$SSI"/etc/isapnp.conf
 cp /etc/issue 		"$SSI"/etc/issue		# Startup Meldung
 cp /etc/issue.net 	"$SSI"/etc/issue.net 		# Startup Meldung
 cp /etc/issue.orig	"$SSI"/etc/issue.orig		# Startup Meldung
 cp /etc/lmhosts	"$SSI"/etc/lmhosts
 cp /etc/logfiles	"$SSI"/etc/logfiles
 cp /etc/login.defs	"$SSI"/etc/login.defs
 cp /etc/mime.types	"$SSI"/etc/mime.types
 cp /etc/mnttab		"$SSI"/etc/mnttab		# Gemountete Devices
 cp /etc/motd 		"$SSI"/etc/motd			# MOTD
 cp /etc/mtab 		"$SSI"/etc/mtab			# Gemountete Devices
 cp /etc/networks	"$SSI"/etc/networks		# ?
 cp /etc/protocols 	"$SSI"/etc/protocols		# TCP/IP Protokolle
 cp /etc/resolv.conf	"$SSI"/etc/resolv.conf		# ?
 cp /etc/route.conf	"$SSI"/etc/route.conf
 cp /etc/rpc		"$SSI"/etc/rpc
 cp /etc/shells		"$SSI"/etc/shells
 cp /etc/services	"$SSI"/etc/services 
 cp /etc/smb.conf	"$SSI"/etc/smb.conf
 cp /etc/ttytype	"$SSI"/etc/ttytype
fi

###########################################################
##
##   V A R   D I R E C T O R Y
##
###########################################################

if test -d /var; then
 cat /var/adm/inst-log/info		> "$SSI"/var/adm/inst-log/info
 cat /var/adm/SuSEconfig/lastrun	> "$SSI"/var/adm/SuSEconfig/lastrun
 cat /var/adm/SuSEconfig/oldhostentry	> "$SSI"/var/adm/SuSEconfig/oldhostentry
fi 

###########################################################
##
##  D E B U G G I N G
##
###########################################################

ls -p -R /proc/[a-z]* /proc/[A-Z]*	> "$SSI"/debug/proc
ls -p /etc  				> "$SSI"/debug/etc

ls -p -s -R /var/adm	 		> "$SSI"/debug/var

###########################################################
##
##  P A A R   S A C H E N   L O E S C H E N
##
###########################################################


 ##############################
 for i in "$SSI"/commands/*; do
  if  test ! -s "$i"; then
    rm "$i"
  fi
 done;

 ##############################
 for i in "$SSI"/dev/*; do
  if  test ! -s "$i"; then
    rm "$i"
  fi
 done;
 
###########################################################
##
##  E N D B E H A N D L U N G
##
###########################################################


# if test ! "$HOSTNAME" = ""; then
#  echo "$LOGNAME"@"$HOSTNAME" 	> "$SSI"/file/user.dat
# else
#  echo "$LOGNAME" 		> "$SSI"/file/user.dat
# fi

 
date 		> "$SSI"/file/date.dat  
#echo "$LOGNAME" > "$SSI"/file/logname.dat 
hostname -f 	> "$SSI"/file/hostname.dat
spider -v 	> "$SSI"/file/version.dat

echo "Spider Sysinfo File" 	> "$SSI"/ID

echo "spider" 			>  "$SSI"/file/creator.dat
echo "$SPIDERVERSION"		>> "$SSI"/file/creator.dat
echo "$LIBVERSION" 		>> "$SSI"/file/creator.dat


# Rechte setzen
chmod -R 777 "$SSI"

###########################################################
##
##  F E H L E R
##
###########################################################

 ############################################
 # HP-UX Version Errors
 #
 # compress	-V
 # dc		--version
 # units	--version
 #
 ############################################
