/*
Qmeter v1.00 Zap's QuickMeter
Copyright (c)1997 Michael Dwyer/N0ZAP (mdwyer@holly.colostate.edu)
13-Mar-97

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



/*
 * idletime
 * IN : Nothing
 * OUT: A float percentage of Idle Time vs Total CPU time since last run. 

 * This function uses the /proc filesystem to read the CPU idle time. It
 * needs to have INVERT defined to tell it which part of the numbers to 
 * return.  See the included config.h file.
 *
 * Basicly, it opens /proc/stat, reads the first line, closes /proc/stat,
 * parses the line, figures out how much the times have changed since the
 * last reading (since stat is cumulative. This is also why really high
 * refresh rates won't work. There won't be any numbers!!). It saves the
 * new numbers, does a little math to get a percentage, then sends this
 * percentage (possibly inverted?) out.
 *
 */
 
#include <stdio.h>
#include "config.h"

float idletime(void)
  {
  FILE *stat;
  char line[80];
  static int user, nice, sys, idle;
  static int ouser, onice, osys, oidle;
  float load;

  if ((stat = fopen("/proc/stat","r")) == NULL)   
     {
     fprintf(stderr, "Unable to open /proc/stat. Do you have a /proc");
     fprintf(stderr, " filesystem? \n");
     exit(0);
     };
  fgets(line, 80, stat);
  sscanf(line,"%*3s %i %i %i %i", &user, &nice, &sys, &idle);
  fclose(stat);

  load = (( (float) (idle-oidle) / (float)
					 ( (user-ouser)
					 + (nice-onice)
					 + (sys - osys)
					 + (idle-oidle)) ) );

  ouser = user;
  onice = nice;
  osys  = sys;
  oidle = idle;

  if (INVERT)
	return(load);
  else
        return (1-load);
  }

/*
 * loadavg
 * IN : Nothing
 * OUT: A float 1-min load average 

 * This function uses the /proc filesystem to read the load average. 
 *
 * Basicly, it opens /proc/loadavg, reads the first line, closes the file,
 * parses the line, then spits back the 1-min load average.
 *
 */
 
float loadavg(void)
  {
  FILE *load;
  char line[80];
  float minavg;

  if ((load = fopen("/proc/loadavg","r")) == NULL)   
     {
     fprintf(stderr, "Unable to open /proc/loadavg. Do you have a /proc");
     fprintf(stderr, " filesystem? \n");
     exit(0);
     };
  fgets(line, 80, load);
  sscanf(line,"%f", &minavg);
  fclose(load);

  return(minavg);
  }
