/*
Qmeter v1.00 Zap's QuickMeter
Copyright (c)1997 Michael Dwyer/N0ZAP (mdwyer@holly.colostate.edu)
13-Mar-1997

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * qmeter.c
 * IN : Nothing
 * OUT: Nothing. But in the process, it makes a pretty light display.
 *
 * This is the main program code for the Quick Meter. It decodes the output
 * from the idletime procedure and operates the lights on the LEDSTAT meter.
 * It requires various DEFINES, but they should all be handled in the 
 * included config.h file.  It also requires the direct port writing 
 * routines porvided by the port.h file.
 *
 * First of all, the led_mask table is used to map the 0-7 number to the
 * correct binary code to write to the LEDSTAT meter. By changing this
 * mask, you could do some weird things with the meter. 
 * The program then opens the IO port. It then puts itself into a 'forever-
 * loop'. Actually, an infinite loop, but I just wanted to put that to annoy 
 * my CS professor. In this loop it calls idletime to get a percent. It turns
 * this percent into an integer from 0 to NUMLITES-1. This number is ran
 * through the correct mask (depending if a heartbeat is used or not) and
 * spit out to the port.
 *
 * A heart cycle is 8 INTERVAL's long. A 'beat' occurs on the Second and
 * Fourth cycle. The heart speed is directly related to the INTERVAL and
 * the BEATLENGTH. Note that if you speed the timing up too much, you 
 * might need to tweek the code to add more 'cycles'.
 * 
 */

#include <stdio.h>
#include <unistd.h>
#include "port.h"
#include "config.h"


void main()
   {

   /* lookup table to use for bit mask */
   /* Directly STOLEN from meter-0.2   */
   static unsigned char led_mask[] =
   {0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff};

   int lights;
   int beat=0;
   int interval;
   float i_idle;

   float idletime();
   float loadavg();

   /*
    * Because of this command (which sets IO Port permissions)
    * this program needs to be SETUID to root or run as root. 
    * I suggest the latter, since any schmuck user should not
    * be plugging weird things into parallel ports... only root.
    */
   if ((ioperm(IOPORT, 1, 1)) == -1)
      {
      fprintf(stderr, "Unable to Access Port. Check CONFIG or run as root. \n");
      exit(0);
      }

   while(1)
      {
      i_idle=idletime();

      if (i_idle > 1.0)
         lights = NUMLITES;
      else
         lights = (int) (i_idle * NUMLITES);

      if (HEARTBEAT)
         {

         if (SCALING)
            interval=(INTERVAL/(loadavg()+1));
         else
            interval=INTERVAL;

         if ((beat==1) || (beat==3))
            {
            port_out(IOPORT, led_mask[lights] ^ BEATMASK);
            usleep(BEATLENGTH*interval);
            port_out(IOPORT, led_mask[lights]);
            usleep(interval-(BEATLENGTH*interval));
            beat++;
            if (beat==9)
               beat=0;
            }
         else
            {
            port_out(IOPORT, led_mask[lights]);
            usleep(interval);
            beat++;
            if (beat==9)
               beat=0;
            }
         }
      else
         {
         port_out(IOPORT, led_mask[lights]);  
         usleep(INTERVAL);                   
         };
      };
   }

