/*-----------------------------------------------------------------------------
 * port.h 
 * Low level I/O functions taken from led-stat.txt
 * Jan 22 95
 *
 * Taken again 19 March 1996 from meter-0.2
 *
 */

/*
 Two files were used: the first is a routine written by a roomate
 (damianf@wpi.edu) used to blast raw bytes at a port, and read them. Please
 contact him for more info, or if you want to use it in a progrm of your own.
 */

#ifndef PORT_H
#define PORT_H

static inline int port_in( int port )
{
   unsigned char value;
  __asm__ volatile ("inb %1,%0"
                    : "=a" (value)
                    : "d" ((unsigned short)port));
   return value;
}

static inline void port_out( unsigned short int port, unsigned char val )
{
  __asm__ volatile (
                    "outb %0,%1\n"
                    :
                    : "a" (val), "d" (port)
                    );
}
#endif /* PORT_H */
/**** END OF FILE ****/
