/*
Qmeter v1.00 Zap's QuickMeter
Copyright (c)1997 Michael Dwyer/N0ZAP (mdwyer@holly.colostate.edu)
13-Mar-97

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * QuickMeter Config File
 *
 * This should probably be configureable from the command line, but
 * I haven't gotten too proficient with that, yet... :(  Besides, this
 * thing is dinky! It compiles in just a few seconds! If you have the
 * standard led-stat parallel port device connected to LPT1, you will
 * not have to change anything in here. The only thing you may want to
 * change is the INTERVAL and the INVERT, but I think they're set nice
 * already... Look at the individual notes.
 */

/*
 * IO Port Selection.  0x378 is LPT1 - 0x278 is LPT2
 *
 * I have seen some pretty wierd port set ups, though.  If you plan to use
 * other than the LPT1, it might be a good idea to find out for sure where
 * your ports are.  AMI BIOSs give a list of them at boot-up. 
 */
#define IOPORT 0x378

/*
 * Number of LEDs to operate. Note that you will have to tweak the
 * led_mask if you want to do more than eight lites. Why would you
 * want to do less? In fact, you'll have to tweek a lot of things.
 * If you want to run more than 8 LEDs, write your own damn program!
 */
#define NUMLITES 8

/*
 * This is the time (in microseconds) that the meter sleeps in between
 * taking samples.  Too high, and the meter is too jumpy and kind of
 * useless and probably pretty CPU intensive in itself. Too low, and
 * it will never register anything. 100,000 seems to be a pretty good
 * interval.
 *
 * If you plan to use a Heartbeat, make sure you check that timing, as
 * well.
 *
 * If scaling is used, this is the base interval, used when the load
 * average is at 0.
 *
 */
#define INTERVAL 100000

/*
 * Setting this to 0 means that when the CPU is idle, no lights are lit
 * Setting this to 1 means that when the CPU is idle, all lights are lit
 */
#define INVERT 0

/*
 * Setting this to 0 means no heartbeat 
 * Setting this to 1 means a lite will blink in a "heartbeat" pattern.
 */
#define HEARTBEAT 1

/*
 * This is the mask used for the heartbeat.  It is X-ORd to whatever
 * comes out of the heartbeat table.  0x80 is the last LED.
 */
#define BEATMASK 0x80

/*
 * This is how long a heartbeat lasts as a percentage of the INTERVAL.
 * .15 seems to be a good number
 *
 * A heart cycle is 8 INTERVAL's long. a 'beat' occurs on the Second and
 * Fourth cycle. The heart speed is directly related to the INTERVAL and
 * the BEATLENGTH. Note that if you speed the timing up too much, you 
 * might need to tweek the code to add more 'cycles'.
 */
#define BEATLENGTH .15

/*
 * This is to turn on heart beat scaling. That is, if you want the heart-
 * beat rate to change with your load average, set this to 1.
 */
#define SCALING 1

