
/* $Id: utils.c,v 1.31 2008/10/31 00:09:57 jayrfink Exp $*/

#include "utils.h"

/*
 * append_file - Appends a string to a logfile. 
 */
void append_file(char *file, char *str)
{
	FILE *fp;

	if ((fp = fopen(file, "a")) == NULL) {
		fprintf(stderr, "File error");
		exit(1);
	}

	fputs(str, fp);
	fputs("\n", fp);

	fclose(fp);
}

/*
 * message_handler - A simple message handler.
 * requires - Message type (print or log), message string and optional
 *            logfile (fill in with NULL or " " if not used)
 */
void message_handler(int type, char *msg, char *file)
{
	char *t = "";
	char *newmsg;
	time_t result;

	/* Format the timestamp */
	result = time(NULL);
	t = asctime(localtime(&result));
	t[strlen(t) - 1] = ' ';
	t[strlen(t)] = 0;

	if (type == 1)
		fprintf(stderr, "%s %s\n", t, msg); 

	if (type == 2) {
		asprintf(&newmsg, "%s %s", t, msg);
		append_file(file, newmsg);
	}
}

/* 
 * Return netmask from prefix /xx 
 */
uint32_t netmask(uint8_t mask)
{
	uint8_t i;
	uint32_t prefix;

	if (mask > 32) {
		printf("Invalid PREFIX: %d\n", mask);
		return 0;
	} else {
		i = 32 - mask;
		prefix = 0xffffffff;

		while (i > 0) {
			prefix = prefix << 1;
			i--;
		}

		return prefix;
	}
}

/* 
 * nrealloc() 
 */
void *nrealloc(void *ptr, size_t size)
{
	void *t;

	if ((t = realloc(ptr, size)) == NULL) {
		perror("Could not resize array !");
		exit(-1);
	} else
		return t;
}

/*
 * Copy an argument vector
 */
char *copy_argv(char **argv)
{
	char **p;
	u_int len = 0;
	char *buf;
	char *src, *dst;

	p = argv;

	if (*p == 0)
		return 0;

	while (*p)
		len += strlen(*p++) + 1;

	buf = (char *) malloc(len);
	if (buf == NULL) {
		fprintf(stdout, "copy_argv: malloc");
		exit(1);
	}

	p = argv;
	dst = buf;
	while ((src = *p++) != NULL) {
		while ((*dst++ = *src++) != '\0');
		dst[-1] = ' ';
	}
	dst[-1] = '\0';

	return buf;
}

/* 
 * call external script with the IP as a single argument 
 */
int exec_script(const char *path, char *ip)
{
	int retval;
	char fullcmd[1024];

	strcpy(fullcmd, path);
	strcat(fullcmd, " ");
	strcat(fullcmd, ip);
#ifdef DEBUG
	printf("debug: calling script %s with argument of %s\n");
#endif
	retval = 0;
	retval = system(fullcmd);

	return (retval);
}


