
/* $Id: nwcore.c,v 1.2 2008/10/31 13:58:14 jayrfink Exp $*/

#include "nw.h"

/*
 * nwcore - This is the pcap looper. It is like most pcap callbacks
 *          except it does two extra things in addition to some basic checks:
 *             - Calls the scoring routines to score a packet's flags
 *             - Calls a results handler to deal with whatever the scoring
 *               match finds (or doesn't)
 */
void nwcore(u_char * args, const struct pcap_pkthdr *header,
	      const u_char * packet)
{
	eth_hdr *ethernet;	/* The ethernet header */
	ip_hdr *ip;		/* The IP header */
	u_int id;		/* Host id */
	u_int i;		/* Counter */
	struct ifreq ifreq;	/* Interface */
	int tmpfds;		/* Temp file descriptor */
	struct sockaddr_in *sin;	/* n/c */
	char ipaddr[32];	/* Our ip addr */
	const struct tcphdr *tcp;	/* TCP Header */
	int len;		/* real length */
	u_int off, version;	/* offset, version */
	u_int length = header->len;	/* length from header */
	char *errormsg;		/* Error message */
	static uint32_t packets_read = 0;	/* packet counter */
	/* Lock */
	m_packet = 1;

	errormsg = NULL;

	if (packets_max != 0) {	/* check if -P is specified */
		packets_read++;	/* increase packets_read */
		if (packets_read == packets_max + 1) {	/* check if we hit our counter */
			fprintf(stdout,
				"Received maximum %u packets\nQuitting...\n",
				packets_max);
			exit(0);	/* kill ourself politely */
		}
	}

	/* Make sure it is not a local packet */
	tmpfds = socket(AF_INET, SOCK_STREAM, 0);
	strlcpy(ifreq.ifr_name, opt.pcap_dev, sizeof(ifreq.ifr_name) - 1);
	if (ioctl(tmpfds, SIOCGIFADDR, &ifreq) == -1) {
		if (errno && errno != ENODEV)
			fprintf(stderr, "ioctl() in pcap_callback():%s\n",
				strerror(errno));
		if (errno == ENODEV)
			fprintf(stderr, "Interface %s does not exist!\n",
				opt.pcap_dev);
	}
	sin = (struct sockaddr_in *) &ifreq.ifr_addr;
	strlcpy(ipaddr, inet_ntoa(sin->sin_addr), sizeof(ipaddr));
	close(tmpfds);

	/* Extract ethernet and ip headers from packet */
	ethernet = (eth_hdr *) (packet);	/* Pointer to ethernet header */
#ifndef DARWIN
	if (strncmp(opt.pcap_dev, "ppp", 3) == 0)
		/* problem with ppp header */
		/* if ppp header then set offset */
		ip = (ip_hdr *) (packet + sizeof(eth_hdr) - 2 +
				 PPP_HDRLEN);
	else
		ip = (ip_hdr *) (packet + sizeof(eth_hdr));	/* Pointer to IP header */
#endif

	if (strncmp(ipaddr, inet_ntoa(ip->ip_src), strlen(ipaddr)) == 0)
		if (strlen(ipaddr) == strlen(inet_ntoa(ip->ip_src)))	/* if pkt from */
			return;	/* our IP then stop */

	if (vflag > 0) {
		printf("read packet: %s->", inet_ntoa(ip->ip_src));
		printf("%s\n", inet_ntoa(ip->ip_dst));
	}

	/* Check netfilters */
	if (netfilter_num > 0) {
		uint8_t hit = 0;
		i = 0;

		while (i < netfilter_num) {
			if ((ntohl(ip->ip_src.s_addr) & netfilter[i].
			     mask) == ntohl(netfilter[i].addr.s_addr))
				hit = 1;
			i++;
		}

		/* IP dont match filtered net */
		if (!hit)
			return;
	}

	/* Add host to tree */
	if ((id = find_host(1, ip->ip_src)) == 0)
		id = add_host(1, ip->ip_src, 1);

	/* These minor alerts we don't care about yet if were in daemon mode */
	if (vflag > 0) {
		/* Safety checks - may need to go somewhere else */
		length -= sizeof(struct ether_header);
		len = ntohs(ip->ip_len);
		off = ntohs(ip->ip_off);
		/* Check for truncated packet */
		if (length < sizeof(struct ip))
			asprintf(&errormsg, "truncated ip %d", length);
		/* Check for missing bytes */
		if (length < len)
			asprintf(&errormsg,
				 "%s truncated %d bytes missing",
				 inet_ntoa(ip->ip_src), len - length);
		/* aka no 1's in the first 13 bits */
		if ((off * 0x1fff) == 1)
			asprintf(&errormsg, "noncontiguos header");

		if (errormsg != NULL) {
			if (!opt.daemon)
				message_handler(1, errormsg, opt.log);

			if (opt.log)
				message_handler(2, errormsg, opt.log);
		}
	}

	/* If we have gotten this far and are in vflag > 1 then go 
	   ahead and start printing to wild abandon Note that we
	   only allocate the tcp data here if want to see it     */
	if (vflag > 1) {
		tcp =
		    (struct tcphdr *) (packet +
				       sizeof(struct ether_header) +
				       sizeof(struct ip));
		fprintf(stdout, "ip: ");
/*		fprintf(stdout, "%s:%u->%s:%u ",
			inet_ntoa(ip->ip_src), tcp->source,
			inet_ntoa(ip->ip_dst), tcp->dest);
*/
		fprintf(stdout,
			"tos %u len %u off %u ttl %u prot %u cksum %u ",
			ip->ip_tos, len, off, ip->ip_ttl, ip->ip_p,
			ip->ip_sum);
		fprintf(stdout, "seq %u ack %u win %u ", tcp->seq,
			tcp->ack, tcp->window);
		printf("\n");
	}

	/* Match rules */
	for (i = 0; i < rules_num; i++) {
		if (match_packet(packet, &rules[i]) == 0) {
			/* Score host */
			if (vflag > 0)
				printf("Scoring host: %s\n\n",
				       inet_ntoa(ip->ip_src));
			score_host(id, rules[i].score);
			/* Stop on quick rule */
			if (rules[i].type == TYPE_QUICK)
				break;
		}
	}

	/* Unlock */
	m_packet = 0;

	/* If the display mutex is set check the score */
	if (m_display) {
#ifdef DEBUG
		printf("debug: coming back to ckpkt()\n");
#endif
		ckpkt(0);
	}
}
