
/* $Id: iptree.c,v 1.3 2008/10/31 13:58:14 jayrfink Exp $*/

#include "nw.h"

int add_host(uint32_t pos, struct in_addr ip, int try_opt)
{
	u_int32_t s;

	/* Optimize tree if needed */
	if (try_opt) {
		if ((level_id > 16) && ((hosts_num * 64) <= max_id)) {
#ifdef DEBUG
			printf
			    ("debug: optimizing hosts tree due low utilization.\n");
#endif

			pack_tree();
		}
	}


	/* Increase tree level if necessary */
	if (pos > max_id) {
		/* Beginnig of new area */
		s = max_id + 1;

		level_id++;
		/* max_id = level_id * level_id - 1; */
		max_id = (max_id + 1) * 2 - 1;

		/* Prepare new level of host tree */
		hosts =
		    nrealloc(hosts, (max_id + 1) * sizeof(struct host));

		bzero((void *) (&hosts[s]),
		      (max_id - s + 1) * sizeof(struct host));
	}

	/* Add host to tree */
	if (hosts[pos].id == 0) {
		char *t;

		hosts[pos].id = pos;
		hosts[pos].addr = ip;
		t = inet_ntoa(ip);
		strncpy(hosts[pos].ipstr, t, 16);
		hosts[pos].pts = 0;

		/* Increase counter of hosts */
		hosts_num++;
#ifdef DEBUG
		printf
		    ("debug: added host at pos: %lu ip: %s num: %lu level: %d maxid: %lu hosts_num : %lu \n",
		     pos, inet_ntoa(hosts[pos].addr), hosts_num, level_id,
		     max_id, hosts_num);
#endif

		return pos;
	}
	/* Try with left children */
	else if (ip.s_addr < hosts[pos].addr.s_addr)
		add_host(hosts[pos].id * 2, ip, 0);
	/* Try with right children */
	else
		add_host(hosts[pos].id * 2 + 1, ip, 0);
}

int find_host(uint32_t pos, struct in_addr ip)
{
	/* Host not found */
	if ((hosts[pos].id == 0) || (pos > max_id))
		return 0;

	/* Host founded */
	if (hosts[pos].addr.s_addr == ip.s_addr)
		return pos;
	/* Try left children */
	else if ((ip.s_addr < hosts[pos].addr.s_addr)
		 && ((pos * 2 + 1) <= max_id))
		find_host(pos * 2, ip);
	/* Try right children */
	else if ((pos * 2 + 1) <= max_id)
		find_host(pos * 2 + 1, ip);
	else
		return 0;
}

int score_host(uint32_t pos, uint16_t score)
{
	/* Score host */
	hosts[pos].pts += score;

	return 0;
}

/* Pack hosts tree */
void pack_tree()
{
	uint32_t i, j, k;	/* Counter variables */

#ifdef DEBUG
	printf("debug: processing pack_tree()\n");
#endif

	/* Prepare temporary hosts table */
	if ((tmphosts =
	     malloc((max_id + 1) * sizeof(struct host))) == NULL) {
		perror("Could not prepare temporary hosts tree !");
		exit(-1);
	}

	/* Clear new hosts table */
	bzero((void *) (tmphosts), (hosts_num + 1) * sizeof(struct host));

	/* Get hosts array from hosts tree */
	browse_tree(1);

	for (i = 0; i <= hosts_num; i++)
		hosts[i] = tmphosts[i];

	/* Sort hosts table */
	qsort((void *) hosts, hosts_num + 1, sizeof(struct host), cmp_ip);
#ifdef DEBUG
	printf("debug: %lu\n", hosts_num);

	for (i = 0; i < hosts_num; i++)
		printf("debug: %s ", hosts[i].ipstr);
	printf("\n");
#endif

	/* Get optimized squention of hosts */
	optimize_tree(0, hosts_num - 1);

	/* Create new optimized tree */
	bzero((void *) (hosts), (max_id + 1) * sizeof(struct host));

	max_id = 1;
	level_id = 1;
	k = hosts_num;
	hosts_num = 0;
#ifdef DEBUG
	printf("debug: %lu\n", k);
#endif

	for (i = 1; i <= k; i++) {
#ifdef DEBUG
		printf
		    ("debug: re-added host ip: %s num: %lu level: %d maxid: %d\n",
		     inet_ntoa(tmphosts[i].addr), hosts_num, level_id,
		     max_id);
#endif
		j = add_host(1, tmphosts[i].addr, 0);
		hosts[j].pts = tmphosts[i].pts;
	}

	/* Free unused temporary hosts table */
	free(tmphosts);

}

/* Prepare optimized sequention of hosts */
void optimize_tree(uint32_t beg, uint32_t end)
{
	u_int32_t t;		/* Temporary position variable */
	static u_int32_t i;	/* Static position in host table */

	if ((beg == 0) && (end == hosts_num - 1))
		i = 1;

	/* Calculate middle position */
	t = (beg + end) / 2;

	/* Save hosts in new table */
	tmphosts[i] = hosts[t];
#ifdef DEBUG
	printf("debug: %lu\n", i);
#endif
	i++;

	/* If beg = end then break tree browsing */
	if (beg == end)
		return;

	/* Optimie left tree */
	if (t > beg)
		optimize_tree(beg, t - 1);
	/* Optimie right tree */
	if (t < end)
		optimize_tree(t + 1, end);

	return;
}

void browse_tree(uint32_t pos)
{
	static u_int32_t i;	/* Static position in host table */

	if (pos == 1)
		i = 0;

	if (hosts[pos].id != 0) {
		if (pos * 2 <= max_id) {
			/* Browse left children */
			browse_tree(pos * 2);
			/* Browse right children */
			browse_tree(pos * 2 + 1);
		}

		/* Save current node in table */
		tmphosts[i] = hosts[pos];
		i++;
	}
}

/* Compare IP */
int cmp_ip(const void *s1, const void *s2)
{
	struct host *h1, *h2;

	h1 = (struct host *) s1;
	h2 = (struct host *) s2;

	return (h1->addr.s_addr > h2->addr.s_addr) ? -1 : 1;

}
