
/* $Id: ckpkt.c,v 1.4 2008/10/31 13:58:14 jayrfink Exp $*/

#include "nw.h"

/*
 * ckpkt: Check the results from a scoring run and pass along a message
 *        _if_ there is a problem; otherwise do nothing.
 */
void ckpkt(int sig)
{

	uint32_t i;		/* Counter */
	char *t = "";		/* Time in string format */
	static uint32_t run_time = 0;	/* Runtime counter */
	char *error_string;	/* Temp holding string */

	/* Increase runtime */
	run_time++;

	/* If we hit refresh time skip */
	if (run_time % opt.refresh == 0) {
		/* Check mutex */
		if (m_packet) {
#ifdef DEBUG
			printf("debug: got_packet()\n");
#endif
			m_display = 1;
			return;
		}

		/* Lock mutex for display() */
		m_display = 1;
#ifdef DEBUG
		printf("debug: eval_packet() routine\n");
#endif

		/* Output handling*/
		for (i = 0; i <= max_id; i++) {
			/* Normal output */
			if (hosts[i].pts >= opt.critical) {
				asprintf(&error_string,
					 "crit: %s scored %d",
					 hosts[i].ipstr, hosts[i].pts);

				if ((error_string)
				    && (!opt.daemon)) {
					message_handler(1, 
							error_string, " ");
				} else
					message_handler(2, 
							error_string, opt.log);


				if (opt.script_crit != NULL)
					exec_script(opt.script_crit,
						    hosts[i].ipstr);

			} else if (hosts[i].pts >= opt.warning) {
				asprintf(&error_string,
					 "warn: %s scored %d ",
					 hosts[i].ipstr, hosts[i].pts);

				if ((error_string)
				    && (!opt.daemon)) {
					message_handler(1, 
							error_string, " ");
				} else
					message_handler(2, 
							error_string, opt.log);

				if (opt.script_warn != NULL)
					exec_script(opt.script_crit,
						    hosts[i].ipstr);
			}
		}

		/* Reset points counter */
		for (i = 0; i <= max_id; i++)
			hosts[i].pts = 0;

		/* Unlock mutex */
		m_display = 0;
	}

	if (opt.timeout != 0 && opt.timeout <= run_time) {	/* it's time to die */
		fprintf(stderr,
			"timeout: (%u seconds) exceeded - Quitting...\n",
			run_time);
		exit(0);
	}
}
