/*
 * $Id: mmon.c,v 0.2 1998/08/22 15:31:49 root Exp $
 * 
 * mmon: uses the lpt port to show information about the system status
 */

#include <unistd.h>
#include <fstream.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <linux/serial_reg.h>
#include "port.h"
#include <signal.h>

static unsigned long irqs[16],oirqs[16];
static unsigned long nd[10][2],ond[10][2];
static char nn[10][10];

static char *device=NULL,irq_selected=0;
static int irq,delay=50,lp=0xffff,cua=0xffff;
static int mirq[8][2],sel_irqs=0;
static char TX='8',RX='8',CD='8';

int getirq(void);
int getnet(void);
int getserial(void);
void HUP_HANDLER(int sig);

int main(int argc,char *argv[]){
   static int i,error=0,file_used=0;
   FILE *f;
   static char *HOME,*vname,*vval;
   
   memset(&mirq,0,sizeof(mirq));
   
   if(getenv("HOME")!=NULL){
      HOME=(char *) malloc(sizeof(strcat(getenv("HOME"),"/.mmonrc")));
      HOME=strcat(getenv("HOME"),"/.mmonrc");
      vname=(char *) malloc(256);
      vval=(char *) malloc(256);
      if((f=fopen(HOME,"rt"))!=NULL){
	 file_used=1;
	 while(fscanf(f,"%s %s",vname,vval)>1){
	    if(!strcasecmp(vname,"lp")){
	       lp=strtol(vval,NULL,0);
	       if(errno==ERANGE) {
		  lp=0xffff;
		  fprintf(stderr,"Error parsing .mmonrc (lp).\n");
		  error=1;
	       }
	    } else if(!strcasecmp(vname,"cua")){
	       cua=strtol(vval,NULL,0);
	       if(errno==ERANGE) {
		  fprintf(stderr,"Error parsing .mmonrc (cua).\n");
		  cua=0xffff;
		  error=1;
	       }
	    } else if((!strncasecmp(vname,"led",3)) && (strlen(vname)==4)){
	       switch(vname[3]){
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		  if(!strcmp(vval,"TX")){
		     TX=(char) vname[3];
		  } else if(!strcmp(vval,"RX")){
		     RX=(char) vname[3];
		  } else if(!strcmp(vval,"CD")){
		     CD=(char) vname[3];
		  } else {
		     irq=strtol(vval,NULL,0);
		     if(((irq>0) && (irq<16)) || ((irq=0) && (!strcmp(vval,"0")))){
			if(sel_irqs<15){
			   mirq[sel_irqs][0]=irq;
			   mirq[sel_irqs++][1]=(char) vname[3]-'0';
			}
		     } else {
			fprintf(stderr,"Error parsing .mmonrc (led%c).\n",vname[3]);
			error=1;
		     }
		  }
	       }
	    } else if(!strcasecmp(vname,"delay")){
	       delay=strtol(vval,NULL,0);
	       if((errno==ERANGE) || (delay==0)) {
		  delay=50;
		  fprintf(stderr,"Error parsing .mmonrc (delay).\n");
		  error=1;
	       }
	    } else if(!strcasecmp(vname,"device")){
	       if((device=(char *) malloc(sizeof(vval)+1))!=NULL){
		  strcpy(device,vval);
		  strcat(device,":");
	       } else {
		  fprintf(stderr,"Error parsing .mmonrc (device). Out of memory ?\n");
		  error=1;
	       }
	    } else fprintf(stderr,"Unknown option in .mmonrc (%s). Ignored\n",vname);
	 }
      }
      free(vname);
      free(vval);
      free(HOME);
      fclose(f);
   }

   if(error) fprintf(stderr,"Errors detected in $HOME/.mmonrc are IGNORED\n");
   
   if(((argc<2) && (!file_used)) || (argc==2)){
      fprintf(stderr,"mmon 0.2, 22-Aug-98\n");
      fprintf(stderr,"Usage: mmon [-p lp] [-0..-7 n/TX/RX/CD] [-s cua] ");
      fprintf(stderr,"[-n device] [-d delay]\n");
      return 1;
   }

   int c=0;
   
   while((c!=-1) && (argc>1)){
      c=getopt(argc,argv,"p:s:0:1:2:3:4:5:6:7:d:n:");
      switch(c){
       case 'p':
	 lp=strtol(optarg,NULL,0);
	 if(errno==ERANGE){
	    fprintf(stderr,"Error parsing -p (%s)\n",optarg);
	    return 1;
	 }
	 break;
       case 's':
	 cua=strtol(optarg,NULL,0);
	 if(errno==ERANGE){
	    fprintf(stderr,"Error parsing -s (%s)\n",optarg);
	    return 1;
	 }
	 break;
       case '0':
       case '1':
       case '2':
       case '3':
       case '4':
       case '5':
       case '6':
       case '7':
	 if((irq=strtol(optarg,NULL,0))==0){
	    if(!strcmp(optarg,"TX")){
	       TX=(char) c;
	    } else if(!strcmp(optarg,"RX")){
	       RX=(char) c;
	    } else if(!strcmp(optarg,"CD")){
	       CD=(char) c;
	    } else if(!strcmp(optarg,"0")){
	       if(sel_irqs<15){
		  mirq[sel_irqs][0]=0;
		  mirq[sel_irqs++][1]=(char) c-'0';
	       } else {
		  fprintf(stderr,"Too many IRQs specified.\n");
		  return 1;
	       }
	    } else {
	       fprintf(stderr,"Unknown or incorrect LED option (%s).\n",optarg);
	       return 1;
	    }
	 } else if((irq>0) && (irq<16)){
	    if(sel_irqs<15){
	       mirq[sel_irqs][0]=irq;
	       mirq[sel_irqs++][1]=(char) c-'0';
	    } else {
	       fprintf(stderr,"Too many IRQs specified.\n");
	       return 1;
	    }
	 } else {
	    fprintf(stderr,"Incorrect IRQ number (%d).\n",irq);
	    return 1;
	 }
	 break;
       case 'd':
	 delay=strtol(optarg,NULL,0);
	 if((errno==ERANGE) || (delay==0)){
	    fprintf(stderr,"Invalid delay (%s).\n",optarg);
	    return 1;
	 }
	 break;
       case 'n':
	 if(device!=NULL) free(device);
	 if((device=(char *) malloc(sizeof(optarg)+1))==NULL){
	    fprintf(stderr,"Error setting device (%s) (Out of memory ?)\n",optarg);
	    return 1;
	 }
	 device=strcat(optarg,":");
	 break;
       case '?':
	 return 1;
	 break;
      }
   }
   
   if(ioperm(lp,1,1)){
      perror("ioperm lp");
      exit(1);
   }
   if(cua<0xffff)
     if(ioperm(cua+UART_MSR,1,1)){
	perror("ioperm cua");
	exit(1);
     }
   signal(15,&HUP_HANDLER);
   while(1==1){
      if(sel_irqs!=0)
	if(getirq()!=0) exit(1);
      if((device!=NULL) && ((RX!='8') || (TX!='8')))
	if(getnet()!=0) exit(1);
      if(CD!='8')
	if(getserial()!=0) exit(1);
      usleep(delay);
   }
}

int getirq(){
   ifstream intfile("/proc/interrupts");
   int intno=0;
   char buf[256];
   
   if(!intfile){
      cerr << "Could not open /proc/interrupts\n";
      return 1;
   }

   while(!intfile.eof()){
      intfile>>intno;
      if(!intfile.eof()){
	 oirqs[intno]=irqs[intno];
	 intfile>>buf;
	 intfile>>irqs[intno];
	 intfile.getline(buf,256);
      }
   }
   for(intno=0;intno<sel_irqs;intno++)
     if(irqs[mirq[intno][0]]!=oirqs[mirq[intno][0]]){
	  port_out(lp,port_in(lp) | ( 1 << (mirq[intno][1])));
       } else {
	  port_out(lp,port_in(lp) & ~( 1 << (mirq[intno][1])));
       }
}

int getnet(void){
   ifstream netfile("/proc/net/dev");
   int count=0,i,size;
   unsigned long t;
   char buf[256];
   char *s;
   
   if(!netfile){
      cerr << "Could not open /proc/net/dev\n";
      return 1;
   }

   netfile.getline(buf,256);
   netfile.getline(buf,256);

   while(!netfile.eof()){
      netfile >> nn[count];
      i=0;size=0;
      while((i<11) && ((char) nn[count][i++]!='\0')) size++;
      s=(char *)malloc(size);
      s[size]='\0';
      memcpy(s,&nn[count],size);
      if(strncasecmp(s,"dummy",5)){
	 if(!netfile.eof()){
	    ond[count][0]=nd[count][0];
	    ond[count][1]=nd[count][1];
	    netfile>>nd[count][0];
	    netfile>>t>>t>>t>>t;
	    netfile>>nd[count][1];
	    netfile.getline(buf,256);
	    if(strcmp(device,s)==0) {
	       if ((nd[count][0]!=ond[count][0]) && (RX!='8')){
		  port_out(lp,port_in(lp) | (1<<(RX-'0')));
	       } else {
		  port_out(lp,port_in(lp) & ~(1<<(RX-'0')));
	       }
	       if ((nd[count][1]!=ond[count][1]) && (TX!='8')){
		  port_out(lp,port_in(lp) | (1<<(TX-'0')));
	       } else {
		  port_out(lp,port_in(lp) & ~(1<<(TX-'0')));
	       }
	       usleep(50);
	    }
	 }
      } else netfile.getline(buf,256);
      free(s);
      count++;
   }
}

int getserial(void){
   int msr;
   
   msr=port_in(cua+UART_MSR);
   if(msr&UART_MSR_DCD){
      port_out(lp,port_in(lp) | (1<<(CD-'0')));
   } else {
      port_out(lp,port_in(lp) & ~(1<<(CD-'0')));
   }
   return 0;
}

void HUP_HANDLER(int sig){
   port_out(lp,0);
   psignal(sig,"mmon");
   exit(0);
}
