/*
 * $Id: mmon.c,v 0.1 1998/08/14 09:17:35 root Exp $
 * 
 * mmon: uses the lpt port to show information about the system status
 */

#include <unistd.h>
#include <fstream.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <linux/serial_reg.h>
#include "port.h"

#undef DEBUG

unsigned long irqs[16],oirqs[16];
unsigned long nd[10][2],ond[10][2];
char nn[10][10];

char *device;
int irq=16;
int delay=50;
int lp=0xffff,cua=0xffff;
char mirq[16][2];
char TX='8',RX='8',CD='8';
int i;

int getirq(void);
int getnet(void);
int getserial(void);
void deb(char str[]);

int main(int argc,char *argv[]){

   for(i=0;i<17;i++){
      mirq[i][0]='0';mirq[i][1]='0';
   }
   
   if(argc<2){
      printf("mmon 0.1, 14-Aug-98\n");
      printf("Usage: %s [-p lpport] [-0..-7 IRQ n/TX/RX] [-s serport]\n",argv[0]);
      printf("          [-n device] [-d delay]\n");
      return 1;
   }

   for(i=1;i<(argc-1);i++){
      if((strcmp(argv[i],"-p"))==0){
	 if(((lp=strtol(argv[i+1],NULL,0))==0) || (lp==ERANGE)){
	    cerr << "Error parsing lpport\n";
	    return 1;
	 }
      }
      if((strcmp(argv[i],"-s"))==0)
	if(((cua=strtol(argv[i+1],NULL,0))==0) || (cua==ERANGE)){
	   cerr << "Error parsing serial\n";
	   return 1;
	}
      if(((char) argv[i][1]>='0') && ((char)argv[i][1]<='7') && ((char) argv[i][0]=='-')){
	 if((strcmp(argv[i+1],"IRQ")==0)){
	    if(((irq=strtol(argv[i+2],NULL,0))>=0) && (irq!=ERANGE)){
	       mirq[irq][0]='1';
	       mirq[irq][1]=(char) argv[i][1];
	    }
	 }
	 if(strcmp(argv[i+1],"TX")==0) TX=(char) argv[i][1];
	 if(strcmp(argv[i+1],"RX")==0) RX=(char) argv[i][1];
	 if(strcmp(argv[i+1],"CD")==0) CD=(char) argv[i][1];
      }
      if((strcmp(argv[i],"-n"))==0){
	if((device=(char *)malloc(sizeof(argv[i+1])+1))==NULL){
	   cerr << "Out of memory !\n";
	   return 1;
	} else {
	   strcat(device,argv[i+1]);
	   strcat(device,":");
	}
      }
      if((strcmp(argv[i],"-d"))==0){
	 if(((delay=strtol(argv[i+1],NULL,0))==0) || (delay==ERANGE)){
	    cerr << "Error parsing delay\n";
	    return 1;
	 }
      }
   }

   if(ioperm(lp,1,1)){
      perror("ioperm lp");
      exit(1);
   }
   if(cua!=0xffff)
     if(ioperm(cua+UART_MSR,1,1)){
	perror("ioperm cua");
	exit(1);
     }
   while(1==1){
      if(irq!=16)
	if(getirq()!=0) exit(1);
      if((device!=NULL) && (RX!='8') && (TX!='8'))
	if(getnet()!=0) exit(1);
      if(cua!=0xffff)
	if(getserial()!=0) exit(1);
      usleep(delay);
   }
}

int getirq(){
   ifstream intfile("/proc/interrupts");
   int intno=0;
   char buf[256];
   
   if(!intfile){
      cerr << "Could not open /proc/interrupts\n";
      return 1;
   }

   while(!intfile.eof()){
      intfile>>intno;
      if(!intfile.eof()){
	 oirqs[intno]=irqs[intno];
	 intfile>>buf;
	 intfile>>irqs[intno];
	 intfile.getline(buf,256);
	 if(mirq[intno][0]=='1'){
	    if(irqs[intno]!=oirqs[intno]){
	       port_out(lp,port_in(lp) | (1<<(mirq[intno][1]-'0')));
	    } else {
	       port_out(lp,port_in(lp) & ~(1<<(mirq[intno][1]-'0')));
	    }
	 }
      }
   }
}

int getnet(void){
   ifstream netfile("/proc/net/dev");
   int count=0,i,size;
   unsigned long t;
   char buf[256];
   char *s;
   
   if(!netfile){
      cerr << "Could not open /proc/net/dev\n";
      return 1;
   }

   netfile.getline(buf,256);
   netfile.getline(buf,256);

   while(!netfile.eof()){
      netfile >> nn[count];
      i=0;size=0;
      while((i<11) && ((char) nn[count][i++]!='\0')) size++;
      s=(char *)malloc(size+1);
      s[size+1]='\0';
      memcpy(s,&nn[count],size);
      if(!netfile.eof()){
	 ond[count][0]=nd[count][0];
	 ond[count][1]=nd[count][1];
	 netfile>>nd[count][0];
	 netfile>>t>>t>>t>>t;
	 netfile>>nd[count][1];
	 netfile.getline(buf,256);
	 if(strcmp(device,s)==0) {
	    if (nd[count][0]!=ond[count][0]){
	       port_out(lp,port_in(lp) | (1<<(RX-'0')));
	    } else {
	       port_out(lp,port_in(lp) & ~(1<<(RX-'0')));
	    }
	    if (nd[count][1]!=ond[count][1]){
	       port_out(lp,port_in(lp) | (1<<(TX-'0')));
	    } else {
	       port_out(lp,port_in(lp) & ~(1<<(TX-'0')));
	    }
	    usleep(50);
	 }
      }
      free(s);
      count++;
   }
}

int getserial(void){
   int msr;
   
   msr=port_in(cua+UART_MSR);
   if(msr&UART_MSR_DCD){
      port_out(lp,port_in(lp) | (1<<(CD-'0')));
   } else {
      port_out(lp,port_in(lp) & ~(1<<(CD-'0')));
   }
   return 0;
}

void deb(char *str){
#ifdef DEBUG
   printf("%s",str);
#endif
}
