/*
 * loadavg.c -- Reads load averages from /proc/loadavg
 *
 * Written by Benjamin Tse (blt@students.cs.mu.oz.au), July 1997
 *
 * Gets loadavg statistics from /proc/loadavg. loadavg() takes three arguments
 * for each of the load averages (one, five and fifteen minutes). Each can
 * be set to NULL to ignore that average. Returns the number of averages
 * read in, -1 on error.
 *
 * Assumes that the file has the format:
 *  <float> <float> <float> <anything else>
 *
 * $Id: loadavg.c,v 1.2 1997/07/15 08:32:04 blt Exp blt $
 */

#include <stdio.h>

#define MAXLEN	100

int
loadavg(float *one, float *five, float *fifteen)
{
    FILE *fp;
    int loads;
    char loadstring[MAXLEN];

    if ((fp = fopen("/proc/loadavg", "r")) == NULL)
    {
        /* problems opening loadavg file */
        return -1;
    }
    
    fgets(loadstring, MAXLEN - 1, fp);

    loads = 0;
    if (one != NULL)
    {
        sscanf(loadstring, "%f %*f %*f", one);
	++loads;
    }
    if (five != NULL)
    {
        sscanf(loadstring, "%*f %f %*f", five);
	++loads;
    }
    if (fifteen != NULL)
    {
        sscanf(loadstring, "%*f %*f %f", fifteen);
	++loads;
    }

    fclose(fp);

    return loads;
}

