/*
 * functions exported from lcd.c
 * 
 * Written by Benjamin Tse, August/October 1995, July 1997
 */

void lcd_control(unsigned short int port, int lcd_on, int cursor_on, int cursor_blink);
void lcd_sysset(unsigned short int port, int eightbit, int twoline, int smallchar);
void lcd_shift(unsigned short int port, int direction, int function);
void lcd_clear(unsigned short int port);
void lcd_home(unsigned short int port);
void lcd_print(unsigned short int port, char c);
void lcd_printstr(unsigned short int port, const char *str);
void lcd_charaddr(unsigned short int port, int x, int y);


#define HEIGHT	80      /* character display range (not viewport) */
#define WIDTH	2

#define STRB 	1	/* negative logic */
#define LF 	2
#define INIT 	4	/* the only positive logic line */
#define SEL 	8

#define RS		STRB
#define RW		LF
#define ENABLE		INIT	/* enable line */
#define METER_OFF	SEL	/* bit to set to disable bar meter */

/* lcd control port values to use for lcd control and character data */
#define CTRL		(RW | RS | METER_OFF)
#define CHAR		(RW | METER_OFF)

/* timings in microseconds */
#define TCYCE		1	/* minimum enable cycle time */

/* for lcd functions */
#define RIGHT		1
#define LEFT		-1

#define DISPLAY		1

