/* lcd4.h   (c)3/97 M.Prinke
 * functions exported from lcd4.c, definitions for 4 bit-mode
 * 
 * Code mainly adapted from the package lcdtime by
 * Benjamin Tse (blt@mundil.cs.mu.oz.au), August/October 1995
 * which uses the LCD-controller's 8 bit-mode.
 */

void lcd_control(unsigned short int port, int lcd_on, int cursor_on, int cursor_blink);
void lcd_sysset(unsigned short int port, int eightbit, int twoline, int smallchar);
void lcd_shift(unsigned short int port, int direction, int function);
void lcd_clear(unsigned short int port);
void lcd_home(unsigned short int port);
void lcd_print(unsigned short int port, unsigned char c);
void lcd_printstr(unsigned short int port, const unsigned char *str);
void lcd_charaddr(unsigned short int port, int x, int y);


#define HEIGHT	80      /* character display range (not viewport) */
#define WIDTH	2

/* LCD control lines <> port bits */
#define RS		16
#define RW		32
#define ENABLE		64
#define METER_OFF	128

/* timings in microseconds */
#define TCYCLE		1	/* minimum enable cycle time */

/* for lcd functions */
#define RIGHT		1
#define LEFT		-1
