/* 
 * memload.c -- get percentage of used memory from /proc
 * (c)2/1997 M.Prinke
 */

#include <stdio.h>

float memload(void)
{
	FILE *f;
	char line[80];
	float load = 0.0, total, used ;

	if((f = fopen("/proc/meminfo","r"))==NULL) {
		fprintf(stderr,"Couldn't open /proc/meminfo.\n");
		exit(1);
	}
	fgets(line, 80, f);
	if(!feof(f)) {
		fgets(line, 80, f);
		sscanf(line,"%*s %f %f",&total,&used);
		load = used/total*100.0;
	}
	/* printf("memory used: %f\n",load); */
	fclose(f);
	return(load);
}
