/* 
 * loadavg.c -- read load average from /proc
 * (c)2/1997 M.Prinke
 */

#include <stdio.h>

float loadavg(void)
{
	FILE *f;
	char line[80];
	float cpu = 0.0;

	if((f = fopen("/proc/loadavg","r"))==NULL) {
		fprintf(stderr,"Couldn't open /proc/loadavg.\n");
		exit(1);
	}

	fgets(line, 80, f);
	if(!feof(f)) {
		/* loadavg: average load last min, last 5mins, last 15mins */
		/* we will use the first */
		sscanf(line,"%f",&cpu);
	}
	/* printf("avg. CPU load: %f\n",cpu); */
	fclose(f);
	return(cpu);
}
