//TOP by mAc

#ifndef MLIST_H
#define MLIST_H 

#include <qwidget.h>
#include <qpushbt.h>
#include <qtablevw.h>
#include <qframe.h>
#include <qpainter.h>
#include <stdio.h>

#ifndef MAXCOL
#define MAXCOL 16
#endif

struct KTableColumns{
 int cn,rn;
 char **clabel;
 int *cwidth;
 char ***cont;
};

class KTableView:public QTableView {
 Q_OBJECT
 public:
   KTableView(KTableColumns *tc,QColor* sc,QFont* sf,
              QWidget* par=0,const char* name=0,
              WFlags f=0);      
   virtual void paintCell(class QPainter *, int, int);      
   virtual int cellWidth(int); 
   void setCellHeight(int h){QTableView::setCellHeight(h);}
   int getNRowsVisible(void){return height()/cellHeight();}
   void select(int row);
public slots: 
  void redraw(){setNumRows( tc->rn );updateTableSize();repaint();}
signals:
  void selItem(int);
  void rmbPress(int,int);
private:
  KTableColumns* tc;
  QFont* font;
  QColor* selcolor;
  int currow;
protected:
  virtual void mousePressEvent(QMouseEvent *e);
  virtual void keyPressEvent(QKeyEvent *e);
};

class KColHdr:public QFrame {
Q_OBJECT
 public:
  KColHdr(char *c,int w,QFont* sf, QWidget* par=0,const char* name=0);
  int w(){return pw;}
  int h(){return QFontMetrics(*font).height()+2;}
  void setw(int sw){pw=sw;}
 signals:
  void mPress(QMouseEvent *e);
  void mRel(QMouseEvent *e);
 protected:
  void drawContents(QPainter *p); 
  virtual void mousePressEvent(QMouseEvent *e){emit mPress(e);}
  virtual void mouseReleaseEvent(QMouseEvent *e){emit mRel(e);}
 private:
  char *caption;
  int pw;
  QFont* font;
};

class KTableHdr:public QFrame {
Q_OBJECT
public:
  KTableHdr(KTableColumns* tc,QFont* sf, QWidget* par=0,const char* name=0);
  virtual void setGeometry(int,int,int,int);
public slots:
  virtual void mousePressEvent(QMouseEvent *e);
  virtual void mouseReleaseEvent(QMouseEvent *e);
signals:
  void switchIt(int);
  void redraw();
private:
  KTableColumns* tc;
  KColHdr *colhdrs[MAXCOL];
  int curcol;
  bool mpress,bresize;
  int whichres,hstartx;
  QFont *font;
protected:
  virtual void mouseMoveEvent(QMouseEvent *);
};

class KMultiList:public QWidget {
  Q_OBJECT
public:
  KMultiList(KTableColumns* tc,QColor* sc,QFont* sf,
             QWidget *parent=0, const char *name=0);
  int getNRowsVisible(void){return Tab->getNRowsVisible();}
  void redrawTable(){Tab->redraw();}
  void select(int row){Tab->select(row);}
protected:
  virtual void resizeEvent(QResizeEvent *);
private:
  KTableView *Tab;
  KTableHdr *hdr;
  QFont* font;
  KTableColumns* tc;
signals:
  void selItem(int);
  void selColumn(int);
  void rmbPress(int,int);
public slots:
  void refreshFont();
};

#endif
