//TOP by mAc

#include "mlist.h"
#include <kapp.h>
#include <qcolor.h>
#include <qstring.h>
#include <qpen.h>
#include <qkeycode.h>

KTableView::KTableView(KTableColumns *t,QColor* sc,QFont* sf,
                       QWidget* par,const char* name,
                       WFlags f):QTableView(par,name,f) {
  font=sf;
  selcolor=sc;
  QFontMetrics fm(*font);
  currow=0;
    tc=t;
    setFocusPolicy( StrongFocus );		// we accept keyboard focus
    setFocus();
    setBackgroundMode( PaletteBase );		// set widgets background
    setNumCols( tc->cn );			// set number of col's in table
    setNumRows( tc->rn );			// set number of rows in table
    setCellWidth( 0 );			// set width of cell in pixels
    setCellHeight( fm.height()+6 );			// set height of cell in pixels
    setTableFlags( Tbl_vScrollBar |		// always vertical scroll bar
		   Tbl_clipCellPainting |	// avoid drawing outside cell
		   Tbl_smoothScrolling);
  updateTableSize();
}

void KTableView::paintCell(class QPainter *p, int y, int x) {
 if(y==currow) {
  p->setBrush(*selcolor);
  p->setPen(NoPen);
  p->drawRect(0,0,cellWidth(x),cellHeight());
  p->setPen(SolidLine);
  p->setPen(white);
 } else {
  p->setPen(black);
 }
 p->setFont(*font);
 p->drawText(2,0,cellWidth(x)-2,cellHeight(),
             AlignLeft|AlignVCenter,tc->cont[x][y]);
}

int KTableView::cellWidth(int n) {
return tc->cwidth[n];
}

void KTableView::mousePressEvent(QMouseEvent *e) {
  int row=findRow(e->y());
  select(row);
  QPoint qp=mapToGlobal(QPoint(e->x(),e->y()));
  if (e->button()==RightButton) emit rmbPress(qp.x(),qp.y());
}

void KTableView::keyPressEvent(QKeyEvent *e) {
 if (e->key()==Key_Up) select(currow-1);
 else if (e->key()==Key_Down) select(currow+1);
 else if (e->key()==Key_Home) select(0);
 else if (e->key()==Key_End) select(numRows()-1);
 else e->ignore();
}

void KTableView::select(int row){
  int oldrow=currow;
  if (row<numRows()&&row>=0) {currow=row;
  if (!rowIsVisible(currow)) {
    if (currow<topCell()) setTopCell(currow);
    if (currow>=lastRowVisible()) setTopCell(currow-getNRowsVisible()+1);
    updateScrollBars();
    }
  emit selItem(currow);
  int y;
  if(rowYPos(oldrow,&y)) repaint(0,y,width(),cellHeight());
  if(rowYPos(currow,&y)) repaint(0,y,width(),cellHeight());}
}

KMultiList::KMultiList(KTableColumns* t,QColor* sc,QFont* sf,
                       QWidget *parent=0, const char *name=0)
          :QWidget(parent,name) {
 if (t->cn>MAXCOL) t->cn=MAXCOL;
 font=sf;
 Tab=new KTableView(t,sc,sf,this,"tab");
 hdr=new KTableHdr(t,sf,this,"hdr");
 refreshFont();
 connect(hdr,SIGNAL(switchIt(int)),this,SIGNAL(selColumn(int)));
 connect(hdr,SIGNAL(redraw()),Tab,SLOT(redraw()));
 connect(Tab,SIGNAL(selItem(int)),this,SIGNAL(selItem(int)));
 connect(Tab,SIGNAL(rmbPress(int,int)),this,SIGNAL(rmbPress(int,int)));
 tc=t;
}

void KMultiList::resizeEvent(QResizeEvent *e){
 //emit Resize(width(),height());
 int fonth=QFontMetrics(*font).height();
 Tab->resize(width(),height()-7-fonth);
 hdr->resize(width(),fonth+6);
}

void KMultiList::refreshFont() {
 int fonth=QFontMetrics(*font).height();
 Tab->setGeometry(0,fonth+7,width(),height()-7);
 Tab->setCellHeight(fonth+6);
 hdr->setGeometry(Tab->x(),Tab->y()-fonth-6,Tab->width(),fonth+6);
}

KTableHdr::KTableHdr(KTableColumns* t,QFont* sf,QWidget* par=0,const char* name=0)
         :QFrame(par,name) {
 tc=t;font=sf;
 curcol=0;
 mpress=FALSE;bresize=FALSE;
 setFrameStyle(Panel|Sunken);
 setLineWidth(1);
 setMouseTracking(TRUE);
 int x=1;
 for (int i=0;i<tc->cn;i++){
  colhdrs[i]=new KColHdr(tc->clabel[i],tc->cwidth[i],sf,this);
  if (i==curcol) colhdrs[i]->setFrameStyle(Panel|Sunken);
  else colhdrs[i]->setFrameStyle(Panel|Raised);
  colhdrs[i]->setGeometry(x,1,0,0);
  x+=tc->cwidth[i];
  connect(colhdrs[i],SIGNAL(mPress(QMouseEvent *)),this,SLOT(mousePressEvent(QMouseEvent *)));
  connect(colhdrs[i],SIGNAL(mRel(QMouseEvent *)),this,SLOT(mouseReleaseEvent(QMouseEvent *)));
 }
}

void KTableHdr::setGeometry(int x,int y,int w,int h) {
 QFrame::setGeometry(x,y,w,h);
 for (int i=0;i<tc->cn;i++) 
  colhdrs[i]->resize(tc->cwidth[i],QFontMetrics(*font).height()+4);
}

void KTableHdr::mouseMoveEvent(QMouseEvent *e) {
 int i;
 if (mpress) {
 int delta=e->x()-hstartx; if (delta<10) delta=10;
  if (bresize) {
   tc->cwidth[whichres]=delta;
   colhdrs[whichres]->setw(delta);
   colhdrs[whichres]->resize(
   colhdrs[whichres]->w(),colhdrs[whichres]->h());
   for (i=whichres+1;i<tc->cn;i++){
    colhdrs[i]->move(colhdrs[i-1]->x()+colhdrs[i-1]->w(),colhdrs[i]->y());
    }
   }
 } else{
 bool res=FALSE;
 int x=1;hstartx=x;
 for (i=0;i<tc->cn;i++) {
  x+=tc->cwidth[i];
  if (e->x()>x-3&&e->x()<x+3) {res=TRUE;whichres=i;break;}
  hstartx=x; 
 }
 if (res) {setCursor(QCursor(sizeHorCursor));bresize=TRUE;}
 else {setCursor(QCursor(arrowCursor));bresize=FALSE;}
 }
}

void KTableHdr::mousePressEvent(QMouseEvent *e) {
grabMouse();mpress=TRUE;
}

void KTableHdr::mouseReleaseEvent(QMouseEvent *e) {
releaseMouse();mpress=FALSE;
if (!bresize){   
   int i;
   int x=1;
   for (i=0;i<tc->cn;i++){
    if (e->x()>x&&e->x()<x+tc->cwidth[i]) 
      {colhdrs[curcol]->setFrameStyle(Panel|Raised);
       colhdrs[curcol]->repaint();
       colhdrs[i]->setFrameStyle(Panel|Sunken);curcol=i;
       colhdrs[i]->repaint();
       emit switchIt(i);break;}
    x+=tc->cwidth[i];}
 }
emit redraw();
}

KColHdr::KColHdr(char *c,int wi,QFont* sf, QWidget* par=0,const char* name=0)
        :QFrame(par,name){
caption=c;
pw=wi;
setMinimumWidth(10);
font=sf;
}

void KColHdr::drawContents(QPainter *p){
 p->setFont(*font);
 p->drawText(3,0,pw-3,QFontMetrics(*font).height()+4,AlignLeft|AlignVCenter,caption);
}


