/* -*- C++ -*- */

/**********************************************************************/
/*   TimeMon (c)  1994  Helmut Maierhofer			      */
/*   KDE-ified M. Maierhofer 1998                                     */
/**********************************************************************/

/*
 * sample.h
 *
 * Definitions for the system dependent sampling class (currently relies
 * on the linux /proc filesystem).
 */

#ifndef SAMPLE_H
#define SAMPLE_H

#ifndef TEST_SAMPLE
# include "../config.h"
#endif

// -- global constants ---------------------------------------------------

const int MAX_CPU = 16;		// max number of CPUS in an SMP machine
				// we get the status for

// -- forward declaration ------------------------------------------------
class KTimeMon;

#ifdef __sun__
struct kstat_ctl;
#endif

// -- class declaration --------------------------------------------------

/*
 * KSample
 *
 * This class is responsible for reading the /proc file system and parsing
 * the system information.
 */
class KSample {
public:
  // -- Sample declaration -----------------------------------------------
  struct Sample {
    unsigned long cputotal;
    unsigned long user, nice, kernel, idle;
    int cpus;
    unsigned long smptotal[MAX_CPU], smpbusy[MAX_CPU];
    unsigned long pin, pout, swin, swout, cswitches;
    unsigned long mtotal, free, buffers, cached, used;
    unsigned long stotal, sused, sfree;
  };

  KSample(KTimeMon *timemon, bool autoScale, unsigned pageScale,
	  unsigned swapScale, unsigned ctxScale);
  virtual ~KSample();

  void setScaling(bool autoScale, unsigned pageScale,
		  unsigned swapScale, unsigned ctxScale);

  Sample getSample(unsigned scale); // returns the current sample
  void updateSample();		// updates the internally stored sample

private:
  void readSample();		// reads a new sample from /proc
  inline unsigned long doScale(unsigned long value, unsigned scale1,
			       unsigned long scale2);

  KTimeMon *timemon;
#ifdef linux
  void parseMtab(char *dest);	// parse /etc/mtab
  char proc[256];		// be sure to change sscanf as well
  int memFD, statFD;
#elif defined(__sun__)
  struct kstat_ctl *kc;
  bool warned;
#endif
  Sample sample, oldSample;
  unsigned pageScale, swapScale, cxScale;
  bool autoscale;
};

#endif // SAMPLE_H
