/**********************************************************************/
/*   TimeMon (c)  1994  Helmut Maierhofer			      */
/*   KDE-ified M. Maierhofer 1998                                     */
/**********************************************************************/

/*
 * confdlg.h
 *
 * Definitions for the timemon configuration dialog.
 */

#include "../config.h"

#include <qgrpbox.h>
#include <qlined.h>
#include <qslider.h>
#include <qlayout.h>
#include <qlabel.h>

#include <kapp.h>
#include <kmsgbox.h>

#include "confdlg.h"
#include "timemon.h"

#include "confdlg.moc"

// -- KConfDialog definition ---------------------------------------------

KConfDialog::KConfDialog(KTimeMon *t) :
  timemon(t), haveWarned(false)
{
  QWidget *w, *p;
  QBoxLayout *bl;
  QGridLayout *gl;
  QLabel *l;
  QSlider *s;
  QGroupBox *b;
  KIntEdit *e;
  KColorButton *cb;
  unsigned i, j;

  setCaption(i18n("KTimeMon Configuration"));

				// first tab: general
  w = new QWidget(this);
  addTab(w, i18n("&General"));

  bl = new QVBoxLayout(w, 5);

  b = new QGroupBox(i18n("Sample Rate"), w);
  bl->addWidget(b, 5);

  gl = new QGridLayout(b, 2, 3, 10);
  gl->addRowSpacing(0, 5);
  gl->setRowStretch(1, 1);
  gl->setColStretch(2, 1);

  p = new QWidget(b);		// placeholder/strut only
  p->setMinimumSize(1, 5);
  p->setMaximumSize(1000, 5);

  for (i = 0; i < 3; i++) gl->addWidget(p, 0, i);

  l = new QLabel(i18n("Interval (ms):"), b);
  l->setMinimumSize(l->sizeHint());
  l->setMaximumSize(1000, l->minimumSize().height());
  gl->addWidget(l, 1, 0);

  intervalEdit = new KIntEdit(b);
  intervalEdit->setMinimumSize(60, intervalEdit->sizeHint().height());
  intervalEdit->setMaximumSize(1000, intervalEdit->minimumSize().height());
  gl->addWidget(intervalEdit, 1, 1);

  s = new QSlider(1, 1000, 100, 1, QSlider::Horizontal, b);
  s->setMinimumSize(s->sizeHint());
  s->setMaximumSize(1000, s->minimumSize().height());
  gl->addWidget(s, 1, 2);

  connect(s, SIGNAL(valueChanged(int)), intervalEdit, SLOT(setIntValue(int)));
  connect(intervalEdit, SIGNAL(valueChanged(int)), s, SLOT(setValue(int)));

  gl->activate();

  bl->addSpacing(20);

				// scaling group box
  b = new QGroupBox(i18n("Scaling"), w);
  bl->addWidget(b, 5);

  gl = new QGridLayout(b, 5, 3, 10);
  gl->addRowSpacing(0, 5);
  for (i = 1; i < 5; i++) gl->setRowStretch(i, 1);
  gl->setColStretch(2, 1);

  for (i = 0; i < 3; i++) gl->addWidget(p, 0, i);

  autoScaleBox = new QCheckBox(i18n("Automatic"), b);
  autoScaleBox->setMinimumSize(autoScaleBox->sizeHint());
  autoScaleBox->setMaximumSize(1000, autoScaleBox->minimumSize().height());
  gl->addMultiCellWidget(autoScaleBox, 1, 1, 0, 2);

  connect(autoScaleBox, SIGNAL(toggled(bool)), this, SLOT(toggle(bool)));

  const char *scaleLabels[3];
  scaleLabels[0] = i18n("Paging:");
  scaleLabels[1] = i18n("Swapping:");
  scaleLabels[2] = i18n("Context Switch:");

  KIntEdit **scaleEdits[3] = { &pageScaleEdit, &swapScaleEdit, &ctxScaleEdit };
  QSlider **scaleSliders[3] = { &pageSlider, &swapSlider, &ctxSlider };
  
  for (i = 0; i < 3; i++) {
    l = new QLabel(scaleLabels[i], b);
    l->setMinimumSize(l->sizeHint());
    l->setMaximumSize(1000, l->minimumSize().height());
    gl->addWidget(l, 2+i, 0);

    e = *scaleEdits[i] = new KIntEdit(b);
    e->setMinimumSize(60, e->sizeHint().height());
    e->setMaximumSize(1000, e->minimumSize().height());
    gl->addWidget(e, 2+i, 1);

    s = *scaleSliders[i] = new QSlider(1, 10000, 1000, 1, 
				       QSlider::Horizontal, b);
    s->setMinimumSize(s->sizeHint());
    s->setMaximumSize(1000, s->minimumSize().height());
    gl->addWidget(s, 2+i, 2);

    connect(s, SIGNAL(valueChanged(int)), e, SLOT(setIntValue(int)));
    connect(e, SIGNAL(valueChanged(int)), s, SLOT(setValue(int)));
  }
  gl->activate();

  bl->addStretch(1);
  bl->activate();


				// second tab: colours
  w = new QWidget(this);
  addTab(w, i18n("&Colours"));

  gl = new QGridLayout(w, 12, 10, 5);

  gl->setColStretch(3, 1); gl->setColStretch(6, 1); // eat up horizontal space
  gl->setRowStretch(11, 1);	// eat up vertical space

  gl->addRowSpacing(0, 20); gl->addRowSpacing(4, 20); gl->addRowSpacing(8, 20);
  gl->addRowSpacing(2, 8); gl->addRowSpacing(6, 8); gl->addRowSpacing(10, 8);

  gl->addColSpacing(0, 10); gl->addColSpacing(9, 25);

  const char *colourBoxLabels[2];
  colourBoxLabels[0] = i18n("CPU/Paging");
  colourBoxLabels[1] = i18n("Memory/Swapping");

  const char *colourLabels[2][3];
  colourLabels[0][0] = i18n("Kernel");
  colourLabels[0][1] = i18n("User");
#if defined(__sun__)
  colourLabels[0][2] = i18n("Wait");
#else
  colourLabels[0][2] = i18n("Nice");
#endif

  colourLabels[1][0] = i18n("Used");
  colourLabels[1][1] = i18n("Buffers");
#if defined(__sun__) || defined(__osf__)
  colourLabels[1][2] = i18n("Kernel");
#else
  colourLabels[1][2] = i18n("Cached");
#endif

  KColorButton **colourButtons[2][3] = { { &kernelCB, &userCB, &niceCB },
					 { &usedCB, &buffersCB, &cachedCB }};
  for (i = 0; i < 2; i++) {
    b = new QGroupBox(colourBoxLabels[i], w);
    gl->addMultiCellWidget(b, 4*i, 4*i+2, 0, 9);

    for (j = 0; j < 3; j++) {
      l = new QLabel(colourLabels[i][j], w);
      l->setMinimumSize(l->sizeHint());
      l->setMaximumSize(l->minimumSize());
      gl->addWidget(l, 4*i+1, 3*j+1, AlignVCenter | AlignRight);

      cb = *colourButtons[i][j] = new KColorButton(white, w);
      cb->setMinimumSize(50, 30);
      cb->setMaximumSize(1000, 30);
      gl->addWidget(cb, 4*i+1, 3*j+2, AlignCenter);

      connect(cb, SIGNAL(changed(const QColor &)), 
	      this, SLOT(updateSampleWidget(const QColor &)));
    }
  }

  b = new QGroupBox(i18n("Swap/Background"), w);
  gl->addMultiCellWidget(b, 8, 10, 0, 6);

  l = new QLabel(i18n("Swap"), w);
  l->setMinimumSize(l->sizeHint());
  l->setMaximumSize(l->minimumSize());
  gl->addWidget(l, 9, 1, AlignVCenter | AlignRight);

  cb = swapCB = new KColorButton(red, w);
  cb->setMinimumSize(50, 30);
  cb->setMaximumSize(1000, 30);
  gl->addWidget(cb, 9, 2);

  connect(cb, SIGNAL(changed(const QColor &)), 
	  this, SLOT(updateSampleWidget(const QColor &)));

  l = new QLabel(i18n("Backgd"), w);
  l->setMinimumSize(l->sizeHint());
  l->setMaximumSize(l->minimumSize());
  gl->addWidget(l, 9, 4, AlignVCenter | AlignRight);

  cb = bgCB = new KColorButton(blue, w);
  cb->setMinimumSize(50, 30);
  cb->setMaximumSize(1000, 30);
  gl->addWidget(cb, 9, 5);

  connect(cb, SIGNAL(changed(const QColor &)), 
	  this, SLOT(updateSampleWidget(const QColor &)));

  b = new QGroupBox(i18n("Sample"), w);
  gl->addMultiCellWidget(b, 8, 10, 7, 9);
  
  sample = new KTimeMonWidget(0, b);
  sample->setGeometry(38, 25, 35, 35);
  
  gl->activate();

				// third tab: interaction
  w = new QWidget(this);
  addTab(w, i18n("&Interaction"));

  bl = new QVBoxLayout(w, 5);

  b = new QGroupBox(i18n("Mouse Events"), w);
  bl->addWidget(b, 5);

  gl = new QGridLayout(b, MAX_MOUSE_ACTIONS + 1, 3, 10);
  gl->addRowSpacing(0, 5);

  for (i = 1; i < MAX_MOUSE_ACTIONS + 1; i++)
    gl->setRowStretch(i, 1);
  gl->setColStretch(2, 1);

  p = new QWidget(b);		// placeholder/strut only
  p->setMinimumSize(1, 5);
  p->setMaximumSize(1000, 5);

  for (i = 0; i < 3; i++) gl->addWidget(p, 0, i);

  const char *buttonText[MAX_MOUSE_ACTIONS] = { "Left button", 
						"Middle button", 
						"Right button" };
  for (i = 0; i < (int) MAX_MOUSE_ACTIONS; i++) {

    l = new QLabel(i18n(buttonText[i]), b);
    l->setMinimumSize(l->sizeHint());
    l->setMaximumSize(1000, l->minimumSize().height());
    gl->addWidget(l, i+1, 0);

    mouseC[i] = new KCombo(false, b);
    mouseC[i]->insertItem("is ignored", KTimeMon::NOTHING);
    mouseC[i]->insertItem("switches mode", KTimeMon::SWITCH);
    mouseC[i]->insertItem("pops up menu", KTimeMon::MENU);
    mouseC[i]->insertItem("starts", KTimeMon::COMMAND);
    mouseC[i]->setCurrentItem(t->mouseAction[i]);
    mouseC[i]->setMinimumSize(mouseC[i]->sizeHint());
    mouseC[i]->setMaximumSize(1000, mouseC[i]->minimumSize().height());
    gl->addWidget(mouseC[i], i+1, 1);

    connect(mouseC[i], SIGNAL(activated(int)), this, 
	    SLOT(mouseInteraction(int)));

    mouseLE[i] = new KLined(b);
    mouseLE[i]->setText(t->mouseActionCommand[i]);
    mouseLE[i]->setMinimumSize(mouseLE[i]->sizeHint());
    mouseLE[i]->setMaximumSize(1000, mouseLE[i]->minimumSize().height());
    gl->addWidget(mouseLE[i], i+1, 2);
  }

  mouseInteraction(0);		// update enable/disable etc

  gl->activate();

  bl->addStretch(1);
  bl->activate();


  setApplyButton();
  setCancelButton();
  resize(380, 300);

  connect(this, SIGNAL(applyButtonPressed()), timemon, SLOT(apply()));
}

// Adjust the colours of the sample widget in the configuration dialog.
void KConfDialog::updateSampleWidget(const QColor &)
{
  sample->kernelColour = kernelCB->color();
  sample->userColour = userCB->color();
  sample->niceColour = niceCB->color();
  sample->cachedColour = cachedCB->color();
  sample->usedColour = usedCB->color();
  sample->buffersColour = buffersCB->color();
  sample->swapColour = swapCB->color();
  sample->bgColour = bgCB->color();
  sample->update();
}

// enable/disable the scale widgets
void KConfDialog::toggle(bool state)
{
  swapScaleEdit->setEnabled(!state);
  pageScaleEdit->setEnabled(!state);
  ctxScaleEdit->setEnabled(!state);
  swapSlider->setEnabled(!state);
  pageSlider->setEnabled(!state);
  ctxSlider->setEnabled(!state);
}

// Check for valid settings.
void KConfDialog::mouseInteraction(int)
{
  int i;
  bool menuOk = false;

  for (i = 0; i < MAX_MOUSE_ACTIONS; i++) {
    unsigned action = mouseC[i]->currentItem();

    if (action == KTimeMon::MENU) menuOk = true;
    mouseLE[i]->setEnabled(action == KTimeMon::COMMAND);
  }

  if (!menuOk && !haveWarned) {
    KMsgBox::message(timemon, i18n("KTimeMon notice"), 
		     i18n("You have set the configuration so that\n"
			  "the pop-up menu cannot be invoked by a\n"
			  "mouse click. This is probably not such a\n"
			  "good idea, because you will have to edit\n"
			  "the configuration options manually to get\n"
			  "rid of this setting..."), KMsgBox::EXCLAMATION);
    haveWarned = true;
  }

}

// update the dialog fields
void KConfDialog::update()
{
  intervalEdit->setValue(timemon->interval);
  kernelCB->setColor(timemon->kernelColour);
  userCB->setColor(timemon->userColour);
  niceCB->setColor(timemon->niceColour);
  buffersCB->setColor(timemon->buffersColour);
  usedCB->setColor(timemon->usedColour);
  cachedCB->setColor(timemon->cachedColour);
  swapCB->setColor(timemon->swapColour);
  bgCB->setColor(timemon->bgColour);
  pageScaleEdit->setValue(timemon->pageScale);
  swapScaleEdit->setValue(timemon->swapScale);
  ctxScaleEdit->setValue(timemon->ctxScale);
  autoScaleBox->setChecked(timemon->autoScale);
  toggle(timemon->autoScale);
  updateSampleWidget(white);	// fake colour
}
