/****************************************************************
**
** Implementation of RAMPanel class
**
****************************************************************/

#include "rampanel.h"

extern "C" {
    #include <stdio.h>
}

const char *RAMPanel::statName = "/proc/meminfo";

// Constructor f. RAM Panel
RAMPanel::RAMPanel(QWidget *parent, const char *name) :
    LPanel(4,"RAM Usage (user/shared/buffers/free)",parent,name)
{
    setIncremental(true);
    setFilled(true);
    
    yScale = 1.00;            // RAM activity measured in range 0..1
    
    colors[0] = QColor(blue);     // User
    colors[1] = QColor(green);    // Shared
    colors[2] = QColor(red);      // buffers
    colors[3] = QColor(darkGray); // Free
    
    // Start timer 
    startTimer(redrawInterval);
}


// Destructor f. RAM Panel
RAMPanel::~RAMPanel()
{
}


// read another Line from virtual RAM Statistics file
//        total:    used:    free:  shared: buffers:  cached:
//Mem:  130887680 127717376  3170304 68497408 28581888 38883328
void RAMPanel::resample() 
{
    char line[255]; // Should be enough
    FILE *inpfile;
    float bTotal, bUsed, bFree, bShared, bBuffers;
    
    inpfile = fopen(statName,"r");
    if (!inpfile) {
        cerr << "RAMPanel::RAMPanel: Could not open file " << statName << endl;
        exit(-1);
    }
    // Get the second line
    fgets(line,sizeof(line),inpfile);
    fgets(line,sizeof(line),inpfile);
    fclose(inpfile);
    
    // Simply parse RAM information
    if (5 != sscanf(line + 5,"%f %f %f %f %f",
                     &bTotal, &bUsed, &bFree, &bShared, &bBuffers) ) {
        cerr << "Unparseable memory information in " << line;
        return;
    }
   
    // Compute resultant percentages
    FArray row(numGraphs);
    row[0] = (bTotal - bShared - bBuffers - bFree) / bTotal;
    row[1] =           bShared                     / bTotal;
    row[2] =                     bBuffers          / bTotal;
    row[3] =                                bFree  / bTotal;
        
    append(row);
}
