// 
// 
// Class Declaration for LPanel: General Panel Functionality for Load Display
// 
// Start: 19980531, UwS
// 
// 
// This is C++ 

#ifndef LPANEL_H
#define LPANEL_H


#include <iostream.h>
#include <fstream.h>
#include <qsize.h>
#include <qwidget.h>
#include <qarray.h>
#include <qcolor.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qtooltip.h>

typedef QArray<float> FArray;


class LPanel : public QWidget
{
    Q_OBJECT
public:    
    LPanel(int n = 0, char *d = 0, QWidget *parent=0, const char *name=0 );
    ~LPanel();

public slots:
    void redraw();

protected:
    int numGraphs; // Number of Graphs
    int xScale;     // One time step makes what x-step?
    float yScale;   // 100% of y() corresponds to: <scale>
    float scaleValue; // if <=0: do not draw scale lines, else: dynamic scaling and lines
    int redrawInterval;
    QString description; // For Tool-Tips
    QColor *colors; // Colours for each Graph
    QColor scaleColor; // Colour for scale Lines
    
    void setFilled(bool);
    void setIncremental(bool);
    bool isFilled() { return (filled); }
    bool isIncremental() { return incremental; }
    int nPoints(void) { return numPoints; }
    void resizeEvent(QResizeEvent *);   
    void append(FArray &); // Insert new column of data
    void timerEvent(QTimerEvent *);
    void paintEvent( QPaintEvent * );
    
    // Make it a pure virtual class
    virtual void resample(void) = 0; // Gain new data
private:
    static const int QSECOND;
    static const int MIN_WIDTH;
    static const int MIN_HEIGHT;
    
    bool incremental; // Are the Graphs to be stacked
    bool filled;      // fill area under graphs
    int numPoints; // actual number of x-range to display
    FArray *data; // Contains Graph Data
    
    void nextColumn();// Prepare for Insertion of next Column
    void lshift(int num = 1); // left shift data by <num> points
};


inline void LPanel::setFilled (bool yesno) 
{
    filled = yesno; 
    if (filled) 
        incremental = true;
}


inline void LPanel::setIncremental (bool yesno)
{
    incremental = yesno;
    if (!incremental) 
        filled = false;
}

    
#endif // LPANEL_H

