/****************************************************************
**
** Implementation of LoadPanel class
**
****************************************************************/

#include "loadpanel.h"

extern "C" {
    #include <stdio.h>
}

const char *LoadPanel::statName = "/proc/loadavg";

// Constructor f. Load Avg. Panel
LoadPanel::LoadPanel(QWidget *parent, const char *name) :
    LPanel(1,"Load Average",parent,name)
{
    setIncremental(false);
    //setFilled(true);
    
    yScale = 1.00; // Initially, but will be overridden with next redraw event
    scaleValue = 1.0;  // Denote dynamic Scaling
    colors[0] = QColor(blue);     
    scaleColor = QColor(black);
    setBackgroundColor(QColor(darkGray));
    
    // Start timer 
    startTimer(redrawInterval);
}


// Destructor f. CPU Panel
LoadPanel::~LoadPanel()
{
}


// read another Line from virtual LoadStatistics file
// 0.09 0.14 0.16 2/79 1166 
void LoadPanel::resample() 
{
    char line[255]; // Should be enough
    FArray load(1);
    FILE *inpfile;

    inpfile = fopen(statName,"r");
    if (!inpfile) {
        cerr << "LoadPanel::LoadPanel: Could not open file " << statName << endl;
        exit(-1);
    }
    fgets(line,sizeof(line),inpfile);
    fclose(inpfile);
    
    // Simply parse CPU information
    if ( 1 != sscanf(line,"%f",&load[0]) ) {
        cerr << "Unparseable load information in " << line;
        return;
    }

    append(load);
    
}
