// C++
//
// $Id: kload.h,v 1.3 1998/07/27 19:27:18 pi Exp $
//
// $Log: kload.h,v $
// Revision 1.3  1998/07/27 19:27:18  pi
// panel visibility mgmt. terminated
//
// 
// 
// Class definition for MyPanel
// 

#include <ktopwidget.h>

#include "cpupanel.h"
#include "rampanel.h"
#include "loadpanel.h"

class PanelSet: public QWidget
{
    Q_OBJECT 
    
private:
    static const WIDTH    =  100;
    static const HEIGHT   =  80;
    static const BORDER   =  5;
        
    static const nPanels  = 3;
    
    int alignment;
    
    //CPUPanel *cpupanel;
    //RAMPanel *rampanel;
    //LoadPanel *loadpanel;
    
    LPanel *myPanel[nPanels];
    bool panelVis[nPanels];
    
    void doResize(void);
    
protected:
    void resizeEvent( QResizeEvent * );
    
public:
    PanelSet(QWidget *parent=0, const char *name=0 );
    ~PanelSet() { /* Do Nothing */ }
    
    static const int A_VERT   =  1;
    static const int A_HORIZ  =  2;
    void setAlignHoriz()       { alignment = A_HORIZ; doResize();}
    void setAlignVert()        { alignment = A_VERT;  doResize();}
    int getAlignment() const   { return alignment; }
    int maxPanels()    const   { return nPanels;   }
    int numVisPanels(void) const; 
    int setPanelVisibility(int, bool);
    bool getPanelVisibility(int i) const { return panelVis[i]; }
};



class KLoad : public KTopLevelWidget
{
    Q_OBJECT 
    
public:
    KLoad(const char *name=0 );
    ~KLoad() {}
    
private slots:
    void alignVert();
    void alignHoriz();
    void visCPU();
    void visRAM();
    void visLoad();
    void writeConfig();
    void about();

protected:

private:    
    // The menu       
    KMenuBar *menu;
      QPopupMenu *mFile;      // File
                              //   Exit
      QPopupMenu *mOptions;   // Options
        QPopupMenu *mAlign;   //   Alignment
          int alignVertId;    //     Vertical
          int alignHorizId;   //     Horizontal
        QPopupMenu *mVisible; //   Active Panels
          int *mVisId;        //     CPU
                              //     RAM
                              //     Load Avg.
      QPopupMenu *mHelp;      // Help
                              //   About
     
    // The top level widget
    PanelSet *panelSet;
    
    void readConfig();
    
    void togglePanelVisibility(int);
    void setPanelVisibility(int, bool);
};

