//
// $Id: kload.cpp,v 1.3 1998/07/27 19:26:43 pi Exp $
//
// $Log: kload.cpp,v $
// Revision 1.3  1998/07/27 19:26:43  pi
// panel visibility mgmt. terminated
//
// 
// Hauptprogramm fuer kload:
// Definition des Applikations-Widget
// 
// 




extern "C" {
    #include <sys/utsname.h>
}

#include <kapp.h>
#include <kconfig.h>
#include <kmenubar.h>
#include <kmsgbox.h> 

#include "kload.h"


// PanelSet Constructor: allocates panel objects
PanelSet::PanelSet(QWidget *parent, const char *name )
        : QWidget(parent,name)
{
    alignment = A_VERT;
    setMinimumSize( WIDTH, HEIGHT);
    
    myPanel[0] = new CPUPanel(this,"CPUPanel");
    panelVis[0] = true;
    myPanel[1] = new RAMPanel(this,"RAMPanel");
    panelVis[1] = true;
    myPanel[2] = new LoadPanel(this,"LoadPanel");
    panelVis[2] = true;
}


// Return number of visible Panels
int PanelSet::numVisPanels(void) const
{
    int i, n;
    
    for (n = 0, i = 0;i < nPanels;i++) {
        n += (panelVis[i] ? 1 : 0);
    }
    
    return n;
}


// 
int PanelSet::setPanelVisibility(int i, bool vis)
{
    // out of range
    if (i >= nPanels)
        return -1;
    // forbid all Panels are hidden
    if (!vis && (numVisPanels() == 1) && panelVis[i])
        return -2;
        
    if (vis && !panelVis[i]) {
        myPanel[i]->show();
        panelVis[i] = true;
    }
    else if (!vis && panelVis[i]) {
        myPanel[i]->hide();
        panelVis[i] = false;
    }
    doResize();
    return 0;
}


void PanelSet::resizeEvent(QResizeEvent *)
{
    doResize();
}


void PanelSet::doResize(void)
{
    int ph, pw, numVisiblePanels, i,offset;
    
    numVisiblePanels = numVisPanels();
    
    if (alignment == A_VERT) {
        pw = width();
        ph = (height() - (numVisiblePanels - 1) * BORDER) / numVisiblePanels;
        
        for (offset = 0, i = 0;i < nPanels;i++) {
            if (panelVis[i]) {
                myPanel[i]->setGeometry(0,
                                        offset,
                                        pw,
                                        ph);
                offset += ph + BORDER;
            }                       
        }
    } 
    else { // alignment == A_HORIZ
        pw = (width() - (numVisiblePanels - 1) * BORDER) / numVisiblePanels;
        ph = height();
        
        for (offset = 0, i = 0;i < nPanels;i++) {
            if (panelVis[i]) {
                myPanel[i]->setGeometry(offset,
                                        0,
                                        pw,
                                        ph);
                offset += pw + BORDER;
            }
        }
    }       
    
}


char *getHostname(void)
{
    static struct utsname u;
    
    if (!uname(&u)) {
        return u.nodename;
    }
    else  {
        return "???";
    }
}



// KLoad Constructor: allocates menu and panel objects
KLoad::KLoad(const char *name )
        : KTopLevelWidget( name )
{
    panelSet = new PanelSet(this,"PanelSet");    
    setView(panelSet);
    
    /////////////////////// Menu: File /////////////////////////////////
    mFile = new QPopupMenu;
    mFile->insertItem(i18n("E&xit"),qApp, SLOT(quit())); 
 

    /////////////////////// Menu: Options /////////////////////////////////
    mAlign = new QPopupMenu;
    mAlign->setCheckable(true);
    alignVertId  = mAlign->insertItem(i18n(
                            "&Vertical Alignment"), this, SLOT(alignVert()));
    alignHorizId = mAlign->insertItem(i18n(
                            "&Horizontal Alignment"), this, SLOT(alignHoriz()));
    mVisible = new QPopupMenu;
    mVisible->setCheckable(true);
    
    mVisId = new int[panelSet->maxPanels()];   
    mVisId[0] = mVisible->insertItem(i18n("&CPU usage"), this, SLOT(visCPU()));
    
    mVisId[1] = mVisible->insertItem(i18n("&RAM usage"), this, SLOT(visRAM()));
    mVisId[2] = mVisible->insertItem(i18n("&Load Avg."), this, SLOT(visLoad()));
    
    mOptions = new QPopupMenu;
    mOptions->insertItem(i18n("&Alignment"),mAlign);
    mOptions->insertItem(i18n("A&ctive Panels"),mVisible);
    mOptions->insertSeparator();
    mOptions->insertItem(i18n("&Save Settings"),this,SLOT(writeConfig()));
 

    /////////////////////// Menu: Help /////////////////////////////////
    mHelp = new QPopupMenu;
    mHelp->insertItem(i18n("&About"),this,SLOT(about()));
    
    /////////////////////// Main Menu //////////////////////////////////
    menu = new KMenuBar(this);
    CHECK_PTR(menu);
    menu->insertItem(i18n("&File"),mFile);
    menu->insertItem(i18n("&Options"),mOptions);
    menu->insertSeparator(); // help Item right justified
    menu->insertItem(i18n("&Help"),mHelp);
    menu->show();
    setMenu(menu);

    // Read Configuration saved to disk
    readConfig();
    
    // Generate caption
    char caption[100];
    sprintf(caption,"kload@%s",getHostname());    
    setCaption(caption);
}



// Display a short message about the author
void KLoad::about()
{
    KMsgBox::message(0,i18n("About kload"),
                i18n("kload 0.5\nUwe Schneider <uwe@richard-schneider.de>\n\n"
                "For the KDE Project!"));
}                     


// Read configuration from standard config file
void KLoad::readConfig()
{
    QString help;
    bool tf;
    
    KConfig *config;
    config = kapp->getConfig();
    
    config->setGroup("General");
    help = config->readEntry("Alignment","Vertical");
    
    if (help == "Horizontal") {
        alignHoriz();
    } else {
        alignVert();
    }

    config->setGroup("CPU Panel");
    tf = config->readBoolEntry("Visible",true);
    setPanelVisibility(0,tf) ;

    config->setGroup("RAM Panel");
    tf = config->readBoolEntry("Visible",true);
    setPanelVisibility(1,tf) ;

    config->setGroup("Load Panel");
    tf = config->readBoolEntry("Visible",true);
    setPanelVisibility(2,tf) ;
}


// Write configuration to standard config file
void KLoad::writeConfig()
{
    int a;
    KConfig *config;
    config = kapp->getConfig();
    
    config->setGroup("General");
    a = panelSet->getAlignment();
    config->writeEntry("Alignment",
                       (a == PanelSet::A_HORIZ) ? "Horizontal" : "Vertical");
                       
    config->setGroup("CPU Panel");
    config->writeEntry("Visible",panelSet->getPanelVisibility(0));
    
    config->setGroup("RAM Panel");
    config->writeEntry("Visible",panelSet->getPanelVisibility(1));
    
    config->setGroup("Load Panel");
    config->writeEntry("Visible",panelSet->getPanelVisibility(2));
       
    config->sync();
}


void KLoad::alignVert()
{
    panelSet->setAlignVert();
    mAlign->setItemChecked(alignVertId,true);
    mAlign->setItemChecked(alignHorizId,false);
}


void KLoad::alignHoriz()
{
    panelSet->setAlignHoriz();
    mAlign->setItemChecked(alignVertId,false);
    mAlign->setItemChecked(alignHorizId,true);
}


void KLoad::visCPU()
{
    togglePanelVisibility(0);
}

void KLoad::visRAM()
{
    togglePanelVisibility(1);
}

void KLoad::visLoad()
{
    togglePanelVisibility(2);
}


// toggle panel visibility state
void KLoad::togglePanelVisibility(int i)
{
    int b = panelSet->getPanelVisibility(i);
    
    if (!panelSet->setPanelVisibility(i,!b)) {
        mVisible->setItemChecked(mVisId[i],!b);
    }
}    


void KLoad::setPanelVisibility(int i, bool tf) 
{
    if (!panelSet->setPanelVisibility(i,tf)) {
        mVisible->setItemChecked(mVisId[i],tf);
    }
   
}


int main( int argc, char **argv )
{
    KApplication *mykapp = new KApplication( argc, argv );
    KLoad w;
    
    mykapp->enableSessionManagement();
    
    mykapp->setMainWidget( &w );
    w.show();
    return mykapp->exec();
}
