/****************************************************************
**
** Implementation of CPUPanel class
**
****************************************************************/

#include "cpupanel.h"

extern "C" {
    #include <stdio.h>
}

const char *CPUPanel::statName = "/proc/stat";

// Constructor f. CPU Panel
CPUPanel::CPUPanel(QWidget *parent, const char *name) :
    LPanel(4,"CPU Load (User/Nice/Sys/Idle)",parent,name)
{
    setIncremental(true);
    setFilled(true);
    
    yScale = 1.00;            // CPU activity measured in range 0..1
    
    colors[0] = QColor(blue);     // User
    colors[1] = QColor(green);   // Nice
    colors[2] = QColor(red);      // Sys
    colors[3] = QColor(darkGray); // Idle
    
    setBackgroundColor(QColor(darkGray));
    
    resample();
    // Start timer 
    startTimer(redrawInterval);
}


// Destructor f. CPU Panel
CPUPanel::~CPUPanel()
{
}


// read another Line from virtual CPU Statistics file
// "cpu  2803260 607720 8126308 187210190"
void CPUPanel::resample() 
{
    char line[255]; // Should be enough
    FILE *inpfile;
    unsigned long jUser, jNice, jSys, jIdle;
    static unsigned long oldjUser = 0,oldjNice = 0, oldjSys = 0, oldjIdle = 0,
                         oldjSum  = 0;
    
    inpfile = fopen(statName,"r");
    if (!inpfile) {
        cerr << "CPUPanel::CPUPanel: Could not open file " << statName << endl;
        exit(-1);
    }
    fgets(line,sizeof(line),inpfile);
    fclose(inpfile);
    
    // Simply parse CPU information
    if ( strncmp(line,"cpu",3) || 
        (4 != sscanf(line + 4,"%lu %lu %lu %lu",&jUser,&jNice,&jSys,&jIdle)) ) {
        cerr << "Unparseable CPU information in " << line;
        return;
    }
    unsigned long jSum = jUser + jNice + jSys + jIdle;
    
    // Compute derivatives
    FArray row(numGraphs);
    if (oldjSum != 0) {
        double deltaJiffies = 1.0 / (jSum - oldjSum);
        row[0] = (jUser - oldjUser) * deltaJiffies;
        row[1] = (jNice - oldjNice) * deltaJiffies;
        row[2] = (jSys  - oldjSys)  * deltaJiffies;
        row[3] = (jIdle - oldjIdle) * deltaJiffies;
        
        append(row);
        //repaint();
    }    
    
    oldjUser = jUser;
    oldjNice = jNice;
    oldjSys  = jSys;
    oldjIdle = jIdle;
    oldjSum  = jSum;
}
