.TH IPS 1 \" -*- nroff -*-
.SH NAME
ips \- intelligent process status
.SH SYNOPSIS
.B ips [column-options] [select-options] [sort-options]
.B [other-options] [macro-names]
.SH DESCRIPTION
.B Ips
is an intelligent ps-like program which displays process status obtained
from the
.I /proc
filesystem.
It is extremely configurable, but is still efficient.
.B Ips
tries to consume as little runtime as possible by only collecting as much
information as is needed for the particular display specified.
.PP
The information to be displayed about processes can be selected on a
column-by-column basis.
Each column displayes one piece of information about the processes.
The set of columns to be displayed and their order may be changed.
.PP
Processes can be selected for displaying based on the values of one or more
columns.
Some selection criteria are pre-defined for efficiency and convenience,
such as the process id and user name.
Other selection criteria can be defined using general expressions
which refer to any combination of the column values.
.PP
The order that processes are displayed is based on sorting the values of
one or more columns.
The set of columns to sort by, the order of the columns for sorting,
and whether each sorting is normal or reversed can be changed.
Arbitrary expressions based on the values of the columns can also be
used for sorting.
.PP
.B Ips
reads initilization files to define macros which make it easy to
specify useful combinations of configuration options.
Therefore many different output formats and short-cuts to common option
combinations can be used.
.PP
.B Ips
normally displays the process status once and then exits,
but it can also act as a
.I top
program to display process status repeatedly.
It has features to make tracking of active and semi-active processes easy.
.PP
Options to
.B ips
are minus signs followed by short words or phrases.
Multiple options cannot be combined together following one minus sign
(unlike the case with many other utilities).
Options are processed in the order that they are given on the command line.
Combinations of options which appear to do conflicting actions are permitted.
This is because each option merely modifies the state left from the previous
options.
The state left after all the options have been processed is the one which is
actually executed.
.SH SPECIFYING COLUMNS FOR OUTPUT
There are many columns of information which can be selected for display.
Each column displays one item of information about the displayed processes.
The set of columns and their order can be specified by the user.
.PP
Each column has a defined width, which is usually adequate to hold the
widest possible data item for that column.
This width is just a default and can be changed if desired.
The data items shown within a column are left justified, right justified,
or centered within the column width according to the type of column.
In some cases the column width might not be adequate to show the complete
data item, and in this case the item is truncated to the column width.
Truncation is indicated by a vertical bar at the right edge of the column.
(The usual columns which require truncation are the
.I command
and
.I environment
columns, which displays the full command line or environment string
for a process.)
.PP
The
.I ips
program enforces a limit on the total width used for displaying of columns.
If too many columns are selected for display, then one or more columns
from the right are removed until the remaining columns fit within the total
width.
The width limit is usually implicitly set by the terminal's width as
returned by the kernel.
But if desired, the width limit can be explicitly specified by the user.
(This is convenient if the
.I ips
program's output is being piped to another process, for example.)
.PP
If the final displayed column does not extend out to the total width limit,
then that column's width is extended to include the remaining columns.
This allows more of the data item to be seen before it requires truncation.
(Typically, the
.I command
column is the rightmost column so as to take advantage of these extra columns.)
.PP
The options for manipulating columns are
.IR -col ,
.IR -addcol ,
.IR -remcol ,
.IR -sep ,
.IR -width ,
.IR -colwidth ,
.IR -vert ,
and
.IR -listcolumns .
.PP
The
.I -col
option first clears any existing list of column names for display,
and then sets the new list of column names to be displayed as specified.
The columns are displayed in the order specified in the option.
If there is a duplicate column name in the list,
then only the last use of the column name is effective.
.PP
The
.I -addcol
option adds the specified columns to the existing list of column names
to be displayed.
The new columns are added in the order specified,
and by default are appended after previously existing columns in the list.
If any of the column names are already in the existing list,
then they are removed from the list before being added back into it.
An argument can be a number, in which case any later column names
are inserted into the list starting at the specified column number.
Out of range column numbers are silently changed to the nearest legal value.
For example,
.B ips -addcol 2 uid gid 999 percentcpu
adds the user id column as column 2, the group id column as column 3,
and appends the percentage cpu column after all other columns.
.PP
The
.I -remcol
option removes the specified columns from the list of column names,
without caring whether or not the columns were in the list.
.PP
The
.I -sep
option specifies the separation between adjacent columns in the display.
It has one argument, which is the number of spaces to insert between each
pair of columns.
The default separation is 2 spaces.
.PP
The
.I -width
option specifies the total width available for the display of columns.
It has one argument, which is the number of columns available.
If this option is not given,
then the width is obtained from the kernel if stdout is a terminal,
or else is set to 80 columns if stdout is not a terminal.
.PP
The
.I -colwidth
option specifies the width of a particular column.
It has one or two arguments.
The first argument is the name of the column whose width is to be set.
The second argument is the desired width of the column.
If the second argument is not given, then the column width is set to
its default value.
.PP
The
.I -vert
option changes the output format from the default horizontal one into a
vertical one.
In vertical format, the status for each process is multi-line where each
displayed value uses a complete line.
The beginning of each line contains the column heading and a colon character,
unless the
.I -noheader
option was used.
Each value is left justified to the same position on the line
and can use the rest of the available output width.
The
.I -sep
option sets the number of spaces between the widest column header and the
beginning of the values.
If multiple processes are being displayed, then a blank line separates their
status lines.
.PP
The
.I -listcolumns
option simply lists the names of the available columns and then exits.
The heading for the column and the default width of the column is also shown.
.SH SELECTION OF PROCESSES FOR DISPLAY
The set of processes to be shown can be specified by a number of options.
Each of these options specifies a condition to be met.
Processes will only be shown which meet all of the specified conditions.
.PP
The options which specify conditions to be met are
.IR -pid ,
.IR -user ,
.IR -group ,
.IR -my ,
.IR -noroot ,
.IR -noself ,
.IR -active ,
.IR -top ,
and
.IR -cond .
.PP
The
.I -pid
option is followed by one or more process ids,
and restricts the display to only the specified processes if they exist.
Using this option multiple times adds to the list of process ids to be shown.
.PP
The
.I -user
option is followed by one or more user names or user ids, and restricts
the display to processes with those user ids if they exist.
Using this option multiple times adds to the list of users to be shown.
.PP
The
.I -group
option is followed by one or more group names or group ids, and restricts
the display to processes with those group ids if they exist.
Using this option multiple times adds to the list of groups to be shown.
.PP
The
.I -my
option only selects process which have my user id.
.PP
The
.I -noroot
option disables selection of processes which run as root.
.PP
The
.I -noself
option removes the
.B ips
process from the display.
.PP
The
.I -active
option only shows processes which are either running or which have run
recently.
.PP
The
.I -top
option limits the display to a specified number of processes.
After displaying the specified number of processes, further ones are ignored.
If no argument is given to the option, then the height of the terminal as
returned by the kernel is used to limit the number of displayed processes.
.PP
The previous options can only select processes which match a small set
of possible conditions.
The
.IR -cond
option is different, and understands general expressions.
The expression is specified in the argument following the option.
(The argument usually needs quoting to avoid being split into multiple
arguments or having its tokens interpreted by the shell.)
.PP
You can select processes matching a condition which is any combination of
the column values for the process.
This is done by specifying an expression to be evaluated for each process.
If the result of the expression is non-zero or non-null, then the
process is selected.
If the expression cannot be evaluated (such as an attempt to divide by zero),
then no error is generated but the process will not be selected.
.PP
Most of the expression syntax from C can be applied to the column values,
such as arithmetic, comparisons, logical ANDs and ORs, the use of parentheses,
the question mark operator, and some built-in functions.
Numeric and string constants can be used within expressions.
Numbers are usually decimal, but are octal if started with a leading 0,
and hex if started with a leading 0x.
Strings are enclosed in a pair of matching single or double quotes.
Generally, string values must be compared with string values,
and numeric values compared with numeric values.
But in some cases numeric values can be converted to strings for comparison.
.PP
Column values are represented in the expressions by their column
names as listed by the
.I -listcolumns
option, where unique abbreviations are allowed.
Values from multiple columns can be used in the same expression,
and can be compared against each other.
Some column values are numeric, whereas other column values are strings.
.PP
The value obtained from using a column name is usually its
.I base
value, which is the unformatted primitive unit of information for the column.
For example, for runtimes, this is the number of
.I jiffies
of runtime the process has used (i.e., 100's of seconds).
A base value can be either a numeric or string value, depending on the column.
.PP
You can apply qualifiers to the column names to use alternate representations
of a column value.
A qualifier is a word following the column name which is separated from it by
a period.
The allowed qualifiers are
.IR base ,
.IR show ,
and
.IR test .
.PP
Using the
.I base
qualifier is the same thing as using the column name by itself (the base value).
.PP
Using the
.I show
qualifier
returns the column value as a string value which is the same as is displayed
for the column.
So for example, for runtimes the
.I show
value contains colons and periods separating hours, minutes,
and parts of seconds.
.PP
Using the
.I test
qualifier
returns a boolean value (1 for TRUE and 0 for FALSE) indicating whether
some useful aspect of the column is true.
The meaning of this test varies depending on the column.
For example, for the column showing the parent pid, the test returns
whether or not the process has a parent (i.e., not 0 or 1).
.PP
There are several functions that can be used within expressions.
These are
.IR min ,
.IR max ,
.IR abs ,
.IR strlen ,
.IR match ,
.IR cmp ,
.IR str ,
and
.IR my .
.PP
The
.IR min ,
.IR max ,
and
.I abs
functions take numeric arguments, and take the minimum of two numbers,
the maximum of two numbers, or the absolute value of a number.
.PP
The
.I strlen
function returns length of the string argument, or if a number was given,
the length of the string representation of that number.
.PP
The
.I cmp
function compares two arguments and returns -1, 0, or 1 according
to whether the first argument is less than, equal to, or greater
than the second argument.
If both arguments are numeric, then the comparison is done on their values.
Otherwise, the comparison is done as a string, converting a numeric argument
to a string value if required.
.PP
The
.I match
function takes two arguments which may be string or numeric values.
Numeric values are converted into the corresponding string value.
The first argument is a string value to be tested.
The second argument is a wildcard pattern to match against.
The wildcard syntax is like filename matching,
so '?' means any single character, '*' means any sequence of characters,
and '[]' matches single occurances of the enclosed characters.
The function returns 1 if the string matches, and 0 if it does not.
.PP
The
.I -str
function converts its argument to a string value.
.PP
The
.I my
function takes one argument, which is a column name (possibly qualified).
It returns the value of that column for the
.B ips
process
.IR itself .
For example,
.I my(ttyname)
returns a string which is my terminal name.
In order to be of maximum use, the
.IR uid ,
.IR user ,
.IR gid ,
and
.I group
columns return the user's real group and user ids for the
.I my
function, even if the
.B ips
program has been made setuid.
.PP
Upper case names can be used within expressions, which are macro names
to be expanded into sub-expressions.
These macro names are defined in the initialization files.
The expansion of the macro must be a complete expression on its own,
with proper use of parenthesis and operators.
The macro name is replaced with the result of evaluating the sub-expression,
and so can be a number or a string.
The definition of a sub-expression can also contain macro names which will
also be evaluated.
.SH SORTING OF DISPLAYED PROCESSES
The default sorting order of displayed processes is by their process id.
But the list of displayed processes can be sorted based on any combination
of the column values.
The columns to be sorted by do not have to be restricted to the set of
columns which are being displayed.
.PP
The first specified sorting column is used to sort the processes.
If two or more processes have the same value for the first sorting column,
then they are sorted by the second specified sorting column (if specified).
This process continues as long as there are sorting columns specified and
any processes still need sorting.
If any processes are still left with matching sorting values after all
the sorting columns have been used,
then the process ids are used for a final sort.
.PP
Sorting on a column can be either a normal sort, or a reverse sort.
In a normal sort, processes with smaller values will be displayed first.
In a reverse sort, processes with larger values will be displayed first.
Values are compared based on the type of column used for sorting.
Some columns sort based on integer values, and some sort based on string
values.
Even if the displayed value is a string,
the sorting may be based on the underlying integral
.I base
value.
(The
.I start-time
column is an example.)
.PP
The
.IR -sort ,
.IR -revsort ,
.IR -sortexpr ,
.IR -revsortexpr ,
and
.I -nosort
options are used to specify sorting values.
.PP
The
.I -sort
and
.I -revsort
options are used to append columns to the sorting list,
either for normal sorting or for reverse sorting.
They are followed by the list of columns to be added for sorting.
.PP
The
.I -sortexpr
and
.I -revsortexpr
options append an arbitrary expression to the sorting list,
either for normal sorting or for reverse sorting.
The expression can be made up of column names, numbers, strings,
and operators, as in the
.I -cond
option.
Sorting is done on the result of the expression which may be a
numeric or string value.
.PP
The
.I -nosort
removes all columns from the sorting list,
leaving only the default sort based on process id.
.SH INITIALIZATION FILES AND MACROS
For convenience and to allow users to configure the output to their liking,
.I ips
reads two initialization files on startup.
The first of the files to be read is the system initialization file
.I /usr/local/lib/ips.init
which is used to set system defaults for
.BR ips .
.PP
The second initialization file to be read is the user initialization file
.I $HOME/.ipsrc
located in each user's home directory.
This allows each user to modify the system defaults for their own use.
The reading of the user's initialization file can be disabled by using
the
.I -noinit
option.
If used, this option must be the first option after the command name.
.PP
The contents of the initialization files are very simple.
Each line of the file can be blank, be a comment, or be a macro definition.
If any line ends in a backslash, then the backslash is replaced by a space
and the next line is appended to it.
Comment lines have a hash mask character as their first non-blank character.
Comment lines and blank lines are ignored.
.PP
The first line of initialization files must consist of the word
.BR #ips# ,
otherwise an error message will be generated and the program will exit.
.PP
Macro definitions are used to replace single arguments on the command line
with possibly large replacement strings with many arguments.
The replacement strings can themselves use macros,
and these new macros are also removed and replaced.
Macro replacement continues until either no more macros remain to be replaced,
or until the allowed macro depth is exceeded.
.PP
Macro names are usually distinguished from non-macros by the fact that
macros begin with upper case letters.
Since column names are all in lower case, there is no problem distinguishing
between a column name and a macro name.
.PP
There are three different types of macros in
.IR ips .
These types are distinguished by the location of the macro usage within the
command line.
The three types of macros are commands, columns, and expressions.
Command macros define a list of command line options and their arguments.
Column macros define a list of column names.
Expression macros define a sub-expression for the
.IR -cond ,
.IR -sortexpr ,
and
.I -revsortexpr
options.
.PP
Because the meaning of these three types of macros differs so much,
and the replacement strings for the macros would generally make no
sense if used for a different type of macro,
the three types of macros have independent name spaces.
This means that the same macro name could be defined three times,
once for each type of macro.  (But this is probably bad practice).
.PP
To define a macro in an initialization file, you use one of the keywords
.IR option ,
.IR column ,
or
.IR expr ,
followed by the macro name and the replacement strings for the macro,
all on one line (taking into account the use of backslashes to continue lines).
The macro names must begin with an upper case letter.
.PP
The
.I option
keyword defines a macro as being one or more command line options.
The replacement string consists of a number of space separated options
and arguments as used on the command line,
including the leading hyphens for the options.
Arguments for options must be contained within the macro expansion itself.
The macro expansion can itself contain macros which will also be expanded
into more options.
.PP
As the single exception to the requirement that macro names are in upper case,
if a word appears on the
.B ips
command line which is not an option, and which cannot be an argument for an
option, then that word with its initial letter converted to upper case is
treated as an option macro to be expanded.
.PP
An important special case of this is a word typed immediately after the
.B ips
program name.
This is typically a macro name which defines a particular format of display.
For example, the command
.B ips top
would expand the option macro named
.B Top
which could be defined to emulate the output of the
.B top
program.
.PP
The
.I column
keyword defines a macro as being a list of column names.
The replacement string consists of a number of space separated column names.
The macro expansion can itself contain macros which will also be expanded
into more column names.
.PP
The
.I expr
keyword defines a macro which is an expression used for the
.IR -cond ,
.IR -sortexpr ,
or
.I -revsortexpr
options.
The replacement string consists of a complete expression using numbers,
strings, column names, and possibly other macros which will also be expanded.
.PP
Here is an example of a valid initialization file:
.sp
.nf
#ips#

# The special command macro run by default
option	SysInit	-col pid parent user summary runtime command


# Definitions for other commands of interest
option	Stop	-cond Stop
option	Cmd	-col pid command -sep 1
option	Env	-col pid environment -sep 1
option	Vert	-vert -sep 1 -col All
option	Mytty	-cond Mytty

option	Top	-sep 1 -col pid user summary runtime \\
		percentcpu command -revsort percentcpu \\
		-sort runorder -loop -clear -top -active


# Definitions for groups of columns
column	Run	runtime idletime percentcpu
column	Regs	eip esp
column	Sigs	signalcatch signalignore signalblock
column	Size	residentsetsize percentmemory size
column	Stdio	stdin stdout stderr

# All columns
column	All	pid parentpid uid user gid group \\
		processgroup ttyprocessgroup \\
		state flags priority \\
		systemtime usertime runtime childruntime \\
		percentcpu runorder \\
		residentsetsize size percentmemory \\
		active idletime starttime age realtimer \\
		eip esp waitchannel \\
		pagefaults minorpagefaults majorpagefaults \\
		signalcatch signalignore signalblock \\
		ttyname ttydevice \\
		openfiles stdin stdout stderr stdio \\
		currentdirectory rootdirectory executable \\
		summary program command environment


# Definitions for expressions used in conditions
expr	Me	(uid == my(uid))
expr	Server	(uid < 100)
expr	User	!Server
expr	Stop	(state == 'T')
expr	Mytty	(ttydev == my(ttydev))
.fi
.PP
The special option macro names of
.B SysInit
and
.B UserInit
are automatically expanded (if they are defined) at the start of every run of
.BR ips .
These macros are used to initialize parameters to default values.
Examples of this initialization is to specify the default list of columns
to be displayed and the default sleep time when looping.
The
.B SysInit
macro definition is usually contained in the system initialization file,
while the
.B UserInit
macro definition is usually contained in the user's initialization file.
Parameters set by these macros can be modified by using options on the
command line.
.SH USEFUL MACROS
The standard supplied system initialization file
.I /usr/local/lib/ips.init
contains many macros of interest.
This section describes some of the standard macros which are provided.
Remember that these macros can be used in lower case on the command line.
.PP
Warning: These macros might not actually work on your system as
described here since they can be changed by the system administrator.
The system administrator may also have added other useful macros which
are not described here.
You should examine the macro definitions in the initialization file
in order to make full use of
.BR ips .
.PP
The default macro
.I SysInit
adds a condition to only show your own processes.
So in order to see other user's processes, you must disable that condition
explicitly or else use a macro which disables it.
The
.I Nocond
macro removes all conditions on the selection of processes allowing you
to see all processes.
.PP
The user name column is not shown by default.
The
.I Long
macro changes the displayed columns to include the user name
and the parent pid.
.PP
The
.I All
macro combines the
.I Nocond
and
.I Long
macros to show all processes in a nice display.
.PP
The
.I Pack
macro shows many useful columns together including the user and group ids,
the state of stdio, and the process age.
.PP
The
.I Cmd
and
.I Env
macros show only the process id and the command line or environment
so that you can see much more of these columns than is usual.
.PP
The
.I Files
macro shows columns related to files, such as the number of open files,
the status of stdio, and the current and root directories.
.PP
The
.I Cpu
macro shows a snapshot display of the currently active processes.
It has a two second sleep in order to detect running processes.
The
.I Top
macro shows the same display format, but in a looping manner and including
recently active processes.
.PP
The width of the runtime columns is not adequate to hold really large runtimes.
The
.I Widerun
macro increases the width of these columns to show larger runtimes.
.PP
The
.I Wide
macro makes the output width be as large as possible,
allowing the showing of very long command lines or environments.
.PP
The
.I Vert
macro sets the output format to vertical and shows every column value.
.PP
The
.I Tty
macro adds a condition to only show processes which are on a terminal.
.PP
The
.I Mytty
macro adds a condition to only show processes which are on your own terminal.
.PP
The
.I Stop
macro adds a condition to show stopped processes.
.SH OTHER FEATURES
There are several other features of
.B ips
which can be specified using command line options.
These options are
.IR -default ,
.IR -read ,
.IR -loop ,
.IR -sleep ,
.IR -clear ,
.IR -initsleep ,
.IR -noheader ,
.IR -activetime ,
.IR -synctime ,
.IR -listmacros ,
.IR -listcolumns ,
.IR -version ,
.IR -end ,
and
.IR -help .
.PP
The
.I -default
option is useful to reset parameters that have been set by previous options.
In particular, it is useful to reset parameters that have been set by the
initialization files.
It accepts one or more option names (without the leading hyphens).
Any parameter set by the indicated option is restored to its initial state
as when the
.B ips
program started.
For example,
.B -default pid
removes any previous restriction on the process ids that can be shown.
.PP
The
.I -loop
option causes
.B ips
to loop forever displaying the process status.
New output iterations are printed following a blank line, unless the
.I -clear
option was also given, in which case the terminal screen is cleared
before each output iteration.
The program sleeps between iterations according to the number of seconds
specified by the
.I -sleep
option.
.PP
The output from the
.I -help
option will briefly describe the use of the remaining options.
.SH COLUMN DESCRIPTIONS
Some of the columns for displaying are self-evident.
But many of them need an explanation, and this is done here.
Due to the permissions on /proc, some of the column values may not be
available for every process.
Columns marked as
.B restricted
are only available if the process has your own user id,
you are running as root, or the
.B ips
program itself is setuid to root.
.PP
The
.I state
column shows the current state of the process.
This is a single letter, where 'R' is runnable, 'D'
is disk I/O, 'T' is stopped, 'S' is sleeping,
and 'Z' is zombie.
.PP
The
.I eip
and
.I esp
columns show the instruction pointer and stack pointer of the process.
The instruction pointer is also known as the program counter, or PC.
.PP
The
.I waitchannel
column shows the address within the kernel that the process is sleeping on.
This is zero if the process is not sleeping.
Usually, different reasons for sleeping use different addresses.
.PP
The
.I program
and
.I command
columns show the program name and command line of the process.
The program name is just the name of the executable file without any
arguments.
The command line shows the arguments that the program was started with.
If no command line arguments were supplied to the program, then this
column shows the program name enclosed in parenthesis.
.PP
The
.I idletime
column shows the number of minutes that the process has been idle.
An idle process is one which has not (detectably) run at all in the
indicated interval.
The idle time is only known by examining processes over time,
and so the true idle time of a process which existed before
.B ips
was run is not known.
In these cases, the idle time is simply the amount of time that
.B ips
has been running, and the times are marked with a leading plus sign.
.PP
The
.I active
column shows whether or not the process has been active.
It shows one of the values "active" or "idle".
This column is provided mainly for use in sorting and selecting.
.PP
The
.I ttyname
and
.I ttydevice
columns show the controlling terminal of the process, which is usually
the terminal where the user logged into.
The device is the kernel's id for the terminal, and is just a number.
The name is found by searching /dev for a character device which has
that same id and then displaying the device name with the /dev removed.
.PP
The
.IR user ,
.IR uid ,
.IR group ,
and
.I gid
columns show the user ids and group ids of a process.
The uid and gid are the numeric ids as used by the kernel.
The user and group are the conversion of those ids to user names and
group names, as found in the /etc/passwd and /etc/group files.
.PP
The
.I percentcpu
column shows the percentage of CPU time that the process has used in the
time interval between samples.
The percentage is 100 times the quotient of the runtime and the elapsed time.
.PP
The
.I residentsetsize
column is the number of K of memory used by the process.
Pages of a process which are not in memory are not counted by this column.
.PP
The
.I starttime
and
.I age
columns show the time at which the process was created.
The start time is the time of day the process started, and if the process
was in existence for over one day, then the number of days previously that
the process was started.
The age is the number of minutes that the process has existed, and is
the difference between the current time and the time that the process
started.
.PP
The
.I flags
column shows some kernel flags associated with the process, in hex.
.PP
The
.IR minorpagefaults ,
.IR majorpagefaults ,
and
.I pagefaults
columns show the number of minor page faults, major page faults,
and the total page faults of the process.
Minor page faults are faults on pages that do not require any disk I/O,
which are copy on write or touching empty pages.
Major page faults are faults which require disk I/O, such as reading in
of text file pages or swap pages.
.PP
The
.IR signalcatch ,
.IR signalignore ,
and
.IR signalblock
columns show the state of signal handling for the process.
Each of these value is a hex value, where signal N is bit number N-1
(counting from bit 0 at the right).
Caught signals are those for which a signal handler is installed.
Ignored signals are those for which the process is ignoring signals.
Blocked signals are those which are pending delivery, but which the
process has blocked from being delivered.
.PP
The
.I openfiles
column displays the number of open files that the process has.
This column is restricted.
.PP
The
.I runorder
column shows the relative run order of the processes.
The run order is a monotonically increasing value representing the
number of process samplings that
.B ips
has made since it started.
Processes are assigned the current run order value whenever they are
seen to have been active since the last sample.
Processes with a larger run order value have run more recently.
.PP
The
.I currentdirectory
column gives the current working directory of the process in the kernel's
internal values of device number and inode number, separated by a colon.
The device number is in hex, and the inode number is in decimal.
This column is restricted.
.PP
The
.I rootdirectory
column gives the root directory of the process in the kernel's
internal values of device number and inode number, separated by a colon.
The device number is in hex, and the inode number is in decimal.
This column is restricted.
.PP
The
.I executable
column gives the device number and inode number of the executable file
for the process, separated by a colon.
The device number is in hex, and the inode number is in decimal.
This column is restricted.
.PP
The
.I priority
column shows the user-specified run priority of the process.
Priority 15 is the default priority.
Priorities larger than 15 have less priority, and are 'niced'.
Priorities smaller than 15 are increased priority.
.PP
The
.I realtimer
column shows the amount of time that the process wants to sleep
before being woken up.
This is either just the number of seconds, or else is the number of
seconds and parts of seconds.
This value does not decrement as time passes, so you don't know when
the sleep time will expire.
.PP
The
.IR stdin ,
.IR stdout ,
and
.I stderr
columns show the files associated with the stdin, stdout, or stderr file
descriptors of the process.
If the file is a character device in /dev (such as a terminal),
then that device name is given.
If the file is a pipe, then the word "pipe" is given along with an id
identifying that particular pipe.
Otherwise, the device and inode of the file is given, separated by a colon.
The device is in hex and the inode is in decimal.
These columns are restricted.
.PP
The
.I stdio
column shows a summary of the files associated with the stdin, stdout,
or stderr file descriptors of the process.
This is in the form of a three character string with one character for
each of the stdin, stdout, and stderr file descriptors.
The character is 'T' for the controlling terminal, 'P'
for a pipe, 'N' for /dev/null, 'F' for some other file, and '-' for a
closed file descriptor (or if the information is unavailable).
This column is restricted.
.PP
The
.I summary
column shows many flag characters which summarize some of the state
of the process.
This consists of a string of 14 characters, where each character is either a
dash or a letter.
A letter indicates the specified condition is true for that character
position, whereas a dash indicates that the condition is false for that
character position.
.PP
Character 1 is the state of the process, except that if the process is
sleeping, then it is 'A' for recently active, or 'I' for idle.
Character 2 is 'W' if the process has no resident memory, and is therefore
swapped out.
Character 3 is 'N' if the process has been niced, and is 'H' if the
process has been given as higher priority than normal.
Character 4 is 'S' if the process is a session id leader.
Character 5 is 'P' if the process is a process group leader.
Character 6 is 'T' if the process has a controlling terminal.
Character 7 is 'F' if the process is a foreground process, which means
that its process group matches its controlling terminal's process group.
Character 8 is 'I' if the process has no parent, meaning it is owned by
.BR init .
Character 9 is 'h' if the process is catching SIGHUP or 'H' if
the process is ignoring SIGHUP.
Character 10 is 't' if the process is catching SIGTERM or 'T' if
the process is ignoring SIGTERM.
Character 11 is 'U' if the process has your user id.
Character 12 is 'G' if the process has your group id.
Character 13 is 'R' if the process is running as root.
Character 14 shows the age of the process.
It is 'N' for a new process, 'M' for a process one minute old, 'F'
for a process five minutes old, 'T' for a process ten minutes old, 'H'
for a process one hour old, 'D' for a process one day old, and 'W'
for a process one week old.
.SH PERFORMANCE
Some data is only collected if the columns using that data are used.
Here 'used' means either displaying, selecting on, or sorting by the column.
Avoiding columns when they are not required will save the time used to
collect that data.
.PP
Most process status is obtained by scanning the /proc directory looking
for filenames which are numeric (which are the process ids).
For each of these processes, the file /proc/<pid>/stat must be
opened and read to collect most of the process status.
Additional files in /proc might need to be read to get the
full status that is required.
.PP
Using the
.I -pid
option will save much work, since then the scan of /proc is avoided and
only the specified process ids will be examined.
Using
.I -noself
avoids looking at our own process.
.PP
Using the
.IR -my ,
.IR -user ,
.IR -group ,
and
.I -noroot
options will save time reading and parsing of the process status for
the eliminated processes, and stop collection of other data for the
eliminated processes.
.PP
The
.I -top
and
.I -cond
options may save time by eliminating the display of process information.
But the information is still collected.
.PP
The
.I -synctime
option changes the interval on which the full process status is collected
for inactive processes.  (See the RISKS section below.)
Setting this to a shorter time interval will increase the runtime.
.PP
The
.I command
column requires the opening and reading of /proc/<pid>/cmdline whenever
the process has changed state or when the synctime has expired.
.PP
The
.I environment
column requires the opening and reading of /proc/<pid>/environ whenver the
process has changed state or when the synctime has expired.
.PP
The
.IR active ,
.IR idletime ,
and
.I percentcpu
columns and the
.I -active
option require that the
.B ips
program sample the processes twice before displaying anything,
with a small sleep between the two samples.
So there will be a delay before seeing anything.
.PP
The
.IR ttyname ,
.IR stdin ,
.IR stdout ,
.IR stderr ,
and
.I stdio
columns require the reading of /dev to find the list of character devices.
This work adds a delay to the program before anything is displayed.
It is only required once per run.
.PP
The
.I openfiles
column requires the reading of all the files in /proc/<pid>/fd whenever
the process has changed state or when the synctime has expired.
.PP
The
.IR stdin ,
.IR stdout ,
.IR stderr ,
and
.I stdio
columns require the opening and reading of one or more of the
/proc/<pid>/fd/<fd> files to obtain their information whenever
the process has changed state or when the synctime has expired.
.PP
The
.I currentdirectory
column requires the reading of the /proc/<pid>/cwd file whenever
the process has changed state or when the synctime has expired.
.PP
The
.I rootdirectory
column requires the reading of the /proc/<pid>/root file whenever
the process has changed state or when the synctime has expired.
.PP
The
.I executable
column requires the reading of the /proc/<pid>/exe file whenever
the process has changed state or when the synctime has expired.
.SH RISKS
The determination of whether a process has been active since the last
sample is not completely foolproof.
Some of the process data is only collected when a process has been active,
or else has not been collected for a while,
and so there is a small risk that the data is obsolete.
The columns which are not necessarily collected on every update are the
ones which require examining /proc files other than the main status file.
These columns include the command line, the environment, the current
directory, and the number of opened files.
.PP
The
.B ips
program checks many process status values to determine whether or
not a process has been active since the last sampling.
If any of these differ from the last sampling, then the process is active.
These values are the process state, runtime, flags, page faults, start time,
stack pointer, instruction pointer, and wait channel.
New process are always active, and processes whose state is 'R' or 'D' are
always active.
.PP
It is possible that a process which wakes up for only a short time,
does very little and then goes back to sleep will appear to be inactive.
(The kernel only has a 1/100 second runtime resolution, and so the
small runtime of the process might not have been seen by the kernel.)
.PP
The
.I -synctime
option can be used to reduce or expand this risk of showing obsolete data.
It accepts the number of seconds at which the complete status of the
process is collected even when it is idle.
It defaults to one minute.
Setting the synctime to zero produces a status with no obsolete data.
.PP
The list of user names, group names, and device names are only collected
when
.B ips
is first started.
Changes to the password file, group files, or device files will not be seen
while the program is running.
.PP
The data collected by
.B ips
is dynamic.
It can change even while the status is being collected for a single process.
So the data shown is only a snapshot and is never absolutely consistent.
.SH LIMITS
The following are some limits to the operation of
.BR ips .
These are compile-time constants, and could be increased if required by
recompiling the program.
.PP
You can only specify 100 process ids for the
.I -pid
option.
.PP
You can only specify 100 user names or ids for the
.I -user
option.
.PP
You can only specify 100 group names or ids for the
.I -group
option.
.PP
You can only have 1000 arguments on a command line.
.PP
The maximum output width is 31K characters, where K is 1024.
.PP
The maximum command string length is 10K.
.PP
The maximum environment string length is 20K.
.PP
The maximum program name string length is 32.
This length is imposed by the kernel which only has a buffer of this size.
.PP
The maximum separation between columns is 20 spaces.
.PP
The maximum depth of expansion of option macros is 20.
.PP
The maximum depth of expansion of expression macros is 20.
.SH BUGS
The
.I -clear
option clears the screen by outputting the ANSI escape sequence for
clearing the screen.
If your terminal does not understand this escape sequence then this
option will not work correctly.
.PP
Using both of the
.I -vert
and
.I -top
options together without any argument does nothing useful.
The number of processes shown will be dependent on the screen height,
but the output will not be limited to the screen height since each process
status prints on multiple lines.
.PP
There are no quoting characters for macro definitions,
so you cannot create single arguments which contain blanks.
This means that if you use the
.IR -cond ,
.IR -sortexpr ,
or
.I -revsortexpr
options in the macro definition file,
then the following expression must not contain any blanks.
However, you
.I can
use blanks in the definition of an expression macro.
.SH FUTURES
I would like to allow macros to accept arguments enclosed in parenthesis,
and have those arguments substituted into the replacement string at the
locations matching parameter names for the macro.
.PP
I would like to allow user-defined columns where the user can define the
format of the data to be displayed using the results of expressions on
other column data.
.PP
I would like to allow commands to be typed to the program while it is
running in loop mode.
These commands would do things like page forwards and backwards through a
long list of processes, turn on or off selection criteria, change the
columns that are being displayed, change the sleep time, and so on.
.PP
I would like to use
.I curses
routines to make the loop display prettier, but only if it is enabled by
a command line option.
.PP
I would like to make an X display for the output in order to reduce the
runtime further by removing xterm from the display process, but only if it
is enabled by a command line option.
The X display could also have some buttons for convenient operations
which would activate particular option macros.
.PP
I would like to add columns giving the absolute pathnames for the current
and root directories.
.PP
I would like to display symbolic strings for the wait channel addresses.
.SH CREDITS
Some of the knowledge on how to process and display the data from /proc
was obtained by reading the procps version 0.97 code by Michael K. Johnson.
.PP
The pattern matching code was adapted from code written by Ingo Wilken.
.SH AUTHOR
.nf
David I. Bell
dbell@auug.org.au
.fi
