/* ESM - An extensible system monitoring tool.
 * Copyright (C) 1999, 2000 Peter Todd <retep@penguinpowered.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* Header file for msg.c */

#ifndef MSG_H
#define MSG_H 1

#ifdef HAVE_REGCOMP
#include <regex.h>
#endif

struct syslogmsg {
  char *msg;
  int urgency;

  struct syslogmsg *next;
  struct syslogmsg *prev;
};

/* The syslogmsg list. Each message recived from syslog is put in this list.
   Whenever we are told to print the syslog this list is read out and printed.
*/
extern struct syslogmsg *syslogmsglist;

/* The number of messages in the msg list. */
extern int nummsgs;

/* The highest urgency level of any message recived since the last report was
   sent.
*/
extern int maxurgency;

void addmsg(struct syslogmsg *newmsg);
void delmsg(struct syslogmsg *msg);

#ifdef HAVE_REGCOMP
/* The array of regex's that are tested against each incoming
   message. */
extern regex_t *regextbl; /* The compiled regex. */
extern int *regpritbl; /* The priority */
extern int regextblnum;

/* Adds regex s of priority p Returns 0 on success, non-zero on
   failure. If this function fails is returns what regcomp
   returned. */
int addregex(char *s,int p);
#endif

#endif /* msg.h */
