/* ESM - An extensible system monitoring tool.
 * Copyright (C) 1999, 2000 Peter Todd <retep@penguinpowered.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* Msglist function. */

#include "main.h"

#include "msg.h"

/* The syslogmsg list. Each message recived from syslog is put in this list.
   Whenever we are told to print the syslog this list is read out and printed.
*/
struct syslogmsg *syslogmsglist = NULL;
struct syslogmsg *syslogmsglist_last = NULL;

/* The number of messages in the msg list. */
int nummsgs = 0;

/* The highest urgency level of any message recived since the last report was
   sent.
*/
int maxurgency = 0;

void addmsg(struct syslogmsg *newmsg){
  int cursavepri;
  struct syslogmsg *curmsg;

  nummsgs++;

  newmsg->next = NULL;
  newmsg->prev = NULL;
  if (syslogmsglist)
    newmsg->next = syslogmsglist;
  else 
    syslogmsglist_last = newmsg;

  syslogmsglist = newmsg;

  if (syslogmsglist->next)
    syslogmsglist->next->prev = syslogmsglist;

  /* Delete a msg. If no msg has a urgency level low enough to delete it 
     keep retrying with higher and higher savepri's.
  */
  cursavepri = savepri;
  while (nummsgs > maxmsgs){
    curmsg = syslogmsglist_last;
    while (1){
      if (curmsg->urgency < cursavepri){
	delmsg(curmsg);
	break;
      }
      else if (curmsg->prev)
	curmsg = curmsg->prev;
      else
	break;
    }
    cursavepri++;
  }
}

/* Deletes a msg. */
void delmsg(struct syslogmsg *msg){
  nummsgs--;

  /* Is the msg at the start the syslogmsg list? */
  if (msg == syslogmsglist){
    /* Set syslogmsglist to msg->next or otherwise set syslogmsglist and syslogmsglist_last to NULL*/
    if (msg->next)
      syslogmsglist = msg->next;
    else{
      syslogmsglist = syslogmsglist_last = NULL;
    }
  }

  /* Is the msg at the end the syslogmsg list? */
  else if (msg == syslogmsglist_last){
    /* Set syslogmsglist to msg->prev If there is no msg->prev then something was screwed up. If there
       was 1 entry in the syslogmsg list we would have found out before.
     */
    if (msg->prev){
      syslogmsglist_last = msg->prev;
      syslogmsglist_last->next = NULL;
    }
    else{
      fprintf(stderr,"Can't happen\n");
      exit(EXIT_FAILURE);
    }
  }
  
  /* We are in the middle of the syslogmsg list. Fix up the prev and next msgs. */
  else{
    if (!msg->next || !msg->prev){
      fprintf(stderr,"Can't happen\n");
      exit(EXIT_FAILURE);
    }      
    msg->next->prev = msg->prev;
    msg->prev->next = msg->next;
  }

  /* Delete the msg. */
  free(msg->msg);
  free(msg);
}

#ifdef HAVE_REGCOMP
regex_t *regextbl = NULL;
int *regpritbl = NULL;
int regextblnum = 0;

int addregex(char *s,int p){
  regextblnum++;
  regextbl = realloc(regextbl,sizeof(regex_t) * regextblnum);
  regpritbl = realloc(regpritbl,sizeof(int) * regextblnum);

  regpritbl[regextblnum - 1] = p;
  return regcomp(regextbl + regextblnum - 1,s,REG_EXTENDED);
}
#endif

static char *id="@(#) $Id: msg.c,v 3.3 2000/04/25 20:56:28 pete Exp $";
