/* ESM - An extensible system monitoring tool.
 * Copyright (C) 1999, 2000 Peter Todd <retep@penguinpowered.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* Header for main.c */

#ifndef MAIN_H
#define MAIN_H 1

#include <common/common.h>

/* Seemed to be needed on FreeBSD for the regex stuff, can't hurt. */
#include <sys/types.h>

/* Any msgs equal or above this priority will cause us to notify emsd
   with a SIGUSR1 */
extern int notifylevel;

/* If more then this number of msg's are recived old msgs are culled
   to make room for new msgs.  */
extern int maxmsgs;

/* When the msg list is culled we don't want to just junk any and all
   msgs. We may want to save some. So any msg with a priority equal or
   greater then savepri will not be culled. However if the first cull
   doesn't kill enough msgs a second run will be conducted with a
   higher savepri. This goes on untill enough msgs have been culled.  */
extern int savepri;

/* Messages >= ignorepri are ignored, though pattern matching is done
   on them. */
extern int ignorepri;

/* No more then 1 forcecheck per forcecheck_interval will ever be
   run. */
extern int forcecheck_interval;

/* The time to wait before sending a forcing a check. */
extern int forcecheck_wait_time;

#endif /* main.h */
