/* ESM - An extensible system monitoring tool.
 * Copyright (C) 1999, 2000 Peter Todd <retep@penguinpowered.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
                                                                                                                           
#include "main.h"

#include <unistd.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "runcmd.h"
#include "options.h"
#include "version.h"

extern char **environ;

/* Runs a command and redirects stdin and stdout to already created (we hope ;) files. */
int re_system_internal (const char *command,const char *stdin_file,const char *stdout_file) {
  int pid;
  char *argv[4];
  char *tmpstr,*tmpstr2;

  if (!daemon_mode)
    printf("Running command %s\n",command);

  if (command == 0)
    return 1;
  pid = fork();
  if (pid == -1)
    return -1;
  if (pid == 0) {

    /* Open the stdin and stdout pipes. */
    freopen(stdin_file,"w+",stdin);
    freopen(stdout_file,"w+",stdout);
    freopen(stdout_file,"w+",stderr);

    tmpstr = strdup(getenv("PATH"));

    tmpstr2 = malloc(strlen("PATH=" PLUGIN_PATH ":") + strlen(tmpstr) + 1);
    tmpstr2 = strcpy(tmpstr2,"PATH=" PLUGIN_PATH ":");
    tmpstr2 = strcat(tmpstr2,tmpstr);

    putenv(tmpstr2);

    argv[0] = "sh";
    argv[1] = "-c";
    argv[2] = (char *)command;
    argv[3] = 0;
    execve("/bin/sh", argv, environ);

    /* Looks like an error happened. Better write a report. */
    printf("BEGIN %s\n",monitorversion);
    printf("URGENCY 5\n");
    printf("REPORT\n");
    #if HAVE_STRERROR
    printf("Error while running %s - %s\n",command,strerror(errno));
    #else
    printf("Error while running %s\n",command);
    #endif
    printf("DONE\n");
    exit(127);
  }

  return pid;
}

/* Runs a command and redirects stdin to a FIFO and stdout to a file. */
int re_system(const char *command,const char *stdin_file,const char *stdout_file){
  /* No need to do anything with FIFO's now... They are created by
     mktmpfifo */
#if 0
  /* Make a FIFO for stdin. */
  mknod(stdin_file,S_IFIFO,0);

  /* Set the permissions on the new pipes. */
  chmod(stdin_file,S_IREAD | S_IWRITE);
#endif

  /* Call re_system_internal to actually run the command. */
  return re_system_internal(command,stdin_file,stdout_file);
}

/* Runs a command and redirects stdin and stdout to a FIFO. */
int re_system2(const char *command,const char *stdin_file,const char *stdout_file){
  /* No need to do anything with FIFO's now... They are created by
     mktmpfifo */
#if 0
  /* Make a FIFO for stdin and stdout. */
  mknod(stdin_file,S_IFIFO,0);
  mknod(stdout_file,S_IFIFO,0);

  /* Set the permissions on the new pipes. */
  chmod(stdin_file,S_IREAD | S_IWRITE);
  chmod(stdout_file,S_IREAD | S_IWRITE);
#endif

  /* Call re_system_internal to actually run the command. */
  return re_system_internal(command,stdin_file,stdout_file);
}

static char *id="@(#) $Id: runcmd.c,v 5.3 2000/04/27 22:21:26 pete Exp $";
