/* ESM - An extensible system monitoring tool.
 * Copyright (C) 1999, 2000 Peter Todd <retep@penguinpowered.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* Makes the system report from the reports made by the monitor
   plugins.  */

#include "main.h"

#include <ctype.h>

#include <sys/types.h>
#include <sys/stat.h>
 
#include "monitor.h"
#include "options.h"
#include "report.h"
#include "version.h"
#include "modulefunc.h"
#include "logfunc.h"
#include "loop.h"

char *sysreport_file;

/* Creates the system report. */
void createsysreport(){
  int i;
  FILE *sysreport_fd;

  /* Open the sysreport file. */
  sysreport_fd = esmd_mktempfile(&sysreport_file);

  /* Obsolete, mktmpfile sets permissions for us. */

  /* Change the permissions of the sysreport file so
     only the we can read/write to it. */
  /*  chmod(sysreport_file,S_IREAD | S_IWRITE); */

  /* Create the header. */
  fprintf(sysreport_fd,"BEGINREPORT %s\n",senderversion);

  /* Copy the internal errors. */
  if (logfile){
    addfile(sysreport_fd,logfile);
    esmd_rmtempfile(logfile);
    logfile = NULL;
  }

  /* Go through each monitor and create the report. */
  if (!just_dmons){
    for (i = 0; i < nummonitors; i++){

      /* Print the name of the monitor. */
      fprintf(sysreport_fd,"MONITOR %s\n",monitorlist[i].title);

      /* Call addfile to add the stdout file to sysreport_fd. */
      addfile(sysreport_fd,monitorlist[i].stdout_file);

      if (!nodelete){
	/* Delete the stdout and stdin files. */
	esmd_rmtempfile(monitorlist[i].stdout_file);
	esmd_rmtempfile(monitorlist[i].stdin_file);
      }

      /* Include a beginning newline in case the monitor didn't
	 have a newline at the end. */
      fprintf(sysreport_fd,"\nDONEMONITOR\n");
    }
  }

  /* Go through each dmonitor and create the report. */
  for (i = 0; i < numdmonitors; i++){

    /* Print the name of the monitor. */
    fprintf(sysreport_fd,"MONITOR %s\n",dmonitorlist[i].title);

    /* Call addfile to add the report file to sysreport_fd. */
    addfile(sysreport_fd,dmonitorlist[i].report_file);

    if (!nodelete){
      /* Delete the report file. */
      esmd_rmtempfile(dmonitorlist[i].report_file);
    }

    /* Include a beginning newline in case the dmonitor didn't
       have a newline at the end. */
    fprintf(sysreport_fd,"\nDONEMONITOR\n");
  }

  fprintf(sysreport_fd,"DONEREPORT\n");

  fclose(sysreport_fd);
}

/* Add a source file to a target fd. */
void addfile(FILE *target,char *sourcename){
  FILE *source;
  char tmpchar;
  int r;

  source = fopen(sourcename,"r");

  while (1){

    r = fscanf(source,"%c",&tmpchar);

    if (r == EOF){
      fclose(source);
      return;
    }


    /* Before we print the character check if it really is
       a valid character for security reasons. */
    if (!(isprint(tmpchar) | isspace(tmpchar)))
      tmpchar = ' ';

    fprintf(target,"%c",tmpchar);
  }
}


static char *id="@(#) $Id: report.c,v 5.2 2000/04/27 01:39:42 pete Exp $";
