/* ESM - An extensible system monitoring tool.
 * Copyright (C) 1999, 2000 Peter Todd <retep@penguinpowered.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
                                                                                                                           /* Header file for monitor.c */

#ifndef MONITOR_H
#define MONITOR_H 1

#include <sys/types.h>
#include <unistd.h>

void runmonitors();

/* MONITOR typedef. */
typedef struct monitor_t {
  char *title;
  char *cmd;
  char *stdin_file;
  char *stdout_file;
  pid_t pid;

  /* The file containing the report generated by the module. */
  char *report_file;

  /* The flags of the monitor. Currently the only valid flag is MONITOR_FLAG_DAEMON */
  int flags;
} MONITOR;

#define MONITOR_FLAG_DAEMON 1

void addmonitor(MONITOR newmon);

/* The list of non-daemon monitors. */
extern MONITOR *monitorlist;
extern int nummonitors;

/* dmonitor.h needs the MONITOR typedef defined. */
#include "dmonitor.h"

#endif /* monitor.h */

