/* ESM - An extensible system monitoring tool.
 * Copyright (C) 1999, 2000 Peter Todd <retep@penguinpowered.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
              
/* Monitor functions. */

#include "main.h"

#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
 
#include "monitor.h"
#include "modulefunc.h"
#include "options.h"
#include "runcmd.h"
#include "version.h"
#include "logfunc.h"

MONITOR *monitorlist;
int nummonitors = 0;

/* Runs all of the monitors once. */
void runmonitors(){
  int i;

  /* Go through the monitor list. Make tmp stdin and stdout files for each command.
     Then run the command. 
  */
  for (i = 0; i < nummonitors; i++){

    if (!daemon_mode)
      printf("Running monitor %s\n",monitorlist[i].title);

    fclose(esmd_mktempfile(&monitorlist[i].stdin_file));
    fclose(esmd_mktempfile(&monitorlist[i].stdout_file));

    monitorlist[i].pid = re_system(monitorlist[i].cmd,monitorlist[i].stdin_file,monitorlist[i].stdout_file);

    /* Did we get -1? If so log the failure. */
    if (monitorlist[i].pid == -1){
      snprintf(errmsg,ERRMSG_MAXLEN,"Couldn't fork while executing %s.\n",monitorlist[i].cmd);
      logmsg(errmsg,ESM_LOG_ERR);
    }
  }

  /* Make all remaining monitors exit. */
  for (i = 0; i < nummonitors; i++){
    wait_module(monitorlist[i].pid,monitortimeout);
  }
}

/* Adds a monitor. */
void addmonitor(MONITOR newmon){
  MONITOR *newspot;

  /* Which monitor list should we add the monitor to? */
  if (!(newmon.flags & MONITOR_FLAG_DAEMON)){
    nummonitors++;
    monitorlist = realloc(monitorlist,sizeof(MONITOR) * nummonitors);
    newspot = &monitorlist[nummonitors - 1];
  }
  else{
    numdmonitors++;
    dmonitorlist = realloc(dmonitorlist,sizeof(MONITOR) * numdmonitors);
    newspot = &dmonitorlist[numdmonitors - 1];
  }

  /* Since the strings are just pointers to a string we have make a
     copy of the strings. Otherwise they might be overwritten later.
  */
  newspot->title = malloc(strlen(newmon.title) + 1);
  newspot->title[0] = '\000';
  newspot->title = strcpy(newspot->title,newmon.title);
  
  newspot->cmd = malloc(strlen(newmon.cmd) + 1);
  newspot->cmd[0] = '\000';
  newspot->cmd = strcpy(newspot->cmd,newmon.cmd);
  
  newspot->flags = newmon.flags;
  newspot->pid = 0;
}

static char *id="@(#) $Id: monitor.c,v 5.3 2000/04/27 01:39:42 pete Exp $";
