/* ESM - An extensible system monitoring tool.
 * Copyright (C) 1999, 2000 Peter Todd <retep@penguinpowered.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* Header file for modulefunc.c */

#ifndef MODULEFUNC_H
#define MOUDLEFUNC_H 1

#include <unistd.h>

void kill_module(pid_t pid);
int wait_module(pid_t pid,int timeout);

struct tmpfile {
  char *name;

  struct tmpfile *next;
  struct tmpfile *prev;

};

/* A linked list of all the temp files. */
extern struct tmpfile *tmpfilelist;

/* Makes a temp file and adds it to the temp file list. Returns the fd
   of the file. Returns the file name in name. */
FILE *esmd_mktempfile(char **name);

/* Makes a temp fifo and adds it to the temp file list. Returns the
   file name in name. */
void esmd_mktempfifo(char **name);

/* Removes a tmpfile from the tmpfile list and deletes the actual
   file. */
void esmd_rmtempfile(char *file); 

/* Removes all temp files. */
void esmd_rmalltmpfiles(void); 

#endif /* modulefunc.h */
