/*
loop.c

The main loop. Does: (in this order)

* If needed loads the config files.

* Runs each monitor.

* Gets the output from each monitor.

* Creates the report.

* Sends the report.

* Sleeps and repeats.
*/

#include "main.h"

#include <unistd.h>
#include <signal.h>

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#include "loop.h"
#include "options.h"
#include "monitor.h"
#include "modulefunc.h"
#include "report.h"
#include "sender.h"
#include "configload.h"

int closenow = 0;

int just_dmons = 0;

/* Main loop. */
void mainloop(){
#ifdef HAVE_MALLINFO
  struct mallinfo minfo;
#endif

  RETSIGTYPE signalhandler(int sig);

  /* setup the signal handler */
  signal(SIGINT, signalhandler);
  signal(SIGTERM, signalhandler);
  signal(SIGHUP, signalhandler);
  signal(SIGQUIT, signalhandler);
  signal(SIGPIPE, signalhandler);
  signal(SIGUSR1, signalhandler);

  while (1){

    if (closenow) goto end;

    /* Do we need to load the config files? */
    if (!haveconfig)
      loadconfig();

    if (closenow) goto end;
    
    /* Run the monitors. */
    if (!just_dmons)
      runmonitors();

    if (closenow) goto end;

    /* Runs the dmonitors. */
    rundmonitors();

    if (closenow) goto end;

    /* Create the report. */
    createsysreport();

    if (closenow) goto end;

    /* Send the report. */
    sendsysreport();

    if (closenow) goto end;

    if (just_dmons)
      just_dmons = 0;

#ifdef HAVE_MALLINFO
    /* Print memory useage stats. */
    if (!daemon_mode){
      minfo = mallinfo();
      printf("%d bytes arena.\n",minfo.arena);
      printf("%d chunks not in use.\n",minfo.ordblks);
      printf("%d bytes used by free chunks.\n",minfo.fordblks);
      printf("%d bytes allocated by malloc.\n",minfo.uordblks);
      printf("%d bytes used by top-most releaseable chunk.\n\n",minfo.keepcost);
    }
#endif

    /* In prior versions we slept for updateinterval - monitortimeout - sendertimeout However in this
       version we have wait_module and don't "take the easy way out"
    */
    sleep(updateinterval);

    if (closenow) goto end;

  }

 end:

  /* Cleanly shutdown. */

  /* Kill all dmonitors. */
  killdmonitors();

  /* Delete all temp files. */
  esmd_rmalltmpfiles();

  /* Delete the pidfile /var/run/esmd.pid */
  remove("/var/run/esmd.pid");

  exit(EXIT_SUCCESS);

}

/* signal handler */
RETSIGTYPE signalhandler(int sig){
  
  if (!daemon_mode)
    printf("Recived signal %d\n",sig);

  if (sig == SIGPIPE)
    ;
  else if (sig == SIGUSR1)
    just_dmons = 1;
  else
    closenow = 1;
  
  return;

}

static char *id="@(#) $Id: loop.c,v 5.4 2000/04/27 22:42:46 pete Exp $";
