/* ESM - An extensible system monitoring tool.
 * Copyright (C) 1999, 2000 Peter Todd <retep@penguinpowered.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* Internal logging functions. */

#include "main.h"

#ifdef HAVE_SYSLOG_H
#include <syslog.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
 
#include "logfunc.h"
#include "options.h"
#include "modulefunc.h"
#include "version.h"

/* The current log file. All errors are sent to this file. */
char *logfile = NULL;

char errmsg[ERRMSG_MAXLEN];

/* Logs a message. msg is the message. urgency is the urgency. 
   
   The correct usage of this function is:

   snprintf(errmsg,ERRMSG_MAXLEN,"some message");
   logmsg(errmsg,urgency);
*/
void logmsg(char *msg,int urgency){
  FILE *logfile_fd;

  /* Is logfile null? */
  if (!logfile)
    logfile_fd = esmd_mktempfile(&logfile);
  else
    /* Open up logfile and make a report. */
    logfile_fd = fopen(logfile,"a");
  

  fprintf(logfile_fd,"MONITOR Internal Error\n");
  fprintf(logfile_fd,"BEGIN %s\n",monitorversion);
  fprintf(logfile_fd,"URGENCY %d\n",urgency);
  fprintf(logfile_fd,"REPORT\n");
  fprintf(logfile_fd,"%s\n",msg);
  fprintf(logfile_fd,"DONE\n");
  fprintf(logfile_fd,"DONEMONITOR\n");

  fclose(logfile_fd);

#ifdef HAVE_SYSLOG_H
  /* Also log to the syslog. */
  openlog("esmd",LOG_PID,LOG_DAEMON);
  
  switch (urgency) {
  case ESM_LOG_EMERG:
    syslog(LOG_EMERG,"%s",msg);
    break;
  case ESM_LOG_ALERT:
    syslog(LOG_ALERT,"%s",msg);
    break;
  case ESM_LOG_CRIT:
    syslog(LOG_CRIT,"%s",msg);
    break;
  case ESM_LOG_ERR:
    syslog(ESM_LOG_ERR,"%s",msg);
    break;
  case ESM_LOG_WARNING:
    syslog(ESM_LOG_WARNING,"%s",msg);
    break;
  case ESM_LOG_NOTICE:
    syslog(ESM_LOG_NOTICE,"%s",msg);
    break;
  case ESM_LOG_INFO:
    syslog(ESM_LOG_INFO,"%s",msg);
    break;
  case ESM_LOG_DEBUG:
    syslog(ESM_LOG_DEBUG,"%s",msg);
    break;
  }
#endif
}

static char *id="@(#) $Id: logfunc.c,v 5.3 2000/04/27 01:39:40 pete Exp $";
