/* ESM - An extensible system monitoring tool.
 * Copyright (C) 1999, 2000 Peter Todd <retep@penguinpowered.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* Stuff used by all of the esm package. */

#ifndef COMMON_H
#define COMMON_H 1

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#ifdef HAVE_LIMITS_H 
/* Needed for strtime2sec error value. */
#include <limits.h>
#else
/* Define some values, all taken from my limit.h */
#define INT_MIN       (-INT_MAX - 1)
#define INT_MAX       2147483647
#endif

/* If needed use our own strdup function. */
#ifndef HAVE_STRDUP
char *strdup(const char *s);
#endif

/* Urgency level #defines */
#define ESM_LOG_EMERG       8       /* system is unusable */
#define ESM_LOG_ALERT       7       /* action must be taken immediately */
#define ESM_LOG_CRIT        6       /* critical conditions */
#define ESM_LOG_ERR         5       /* error conditions */
#define ESM_LOG_WARNING     4       /* warning conditions */
#define ESM_LOG_NOTICE      3       /* normal but significant condition */
#define ESM_LOG_INFO        2       /* informational */
#define ESM_LOG_DEBUG       1       /* debug-level messages */

/* Maintainer email address */
#define MAINTAINER_EMAIL_ADDRESS "retep@penguinpowered.com"

/* Converts a string with the log level into the numerical log
   level. Converts s to uppercase before testing. Returns -1 on error.

   Valid log levels are esm_log_l, log_l and l where s is the
   level. As a special case error may be used instead of err, critical
   instead of crit etc. */
int str2loglevel(char *s);

/* Converts a time with one of the standard suffixes (s, h, d or none)
   into seconds. Returns INT_MIN on error. */
int strtime2sec(char *s);

/* Makes a new temp file and returns the fd of the temp file. The name
   of the temp file is returned in name. (name should be freed when
   not needed, if name is null the name of the temp file will not be
   stored in name) This function is secure. It first opens the file
   with open with the O_CREAT and O_EXCL flags. Then the file is
   fchmoded to 600 Then it's finally opened again with fdopen to get a
   stdio file handle.

   Now is this correct? :( */
FILE *mktmpfile(char **name);

/* Same as mktmpfile but makes a new FIFO and doesn't open the
   FIFO. Returns -1 on error, 0 on success. */
int mktmpfifo(char **name);

#endif /* common.h */
