/* ESM - An extensible system monitoring tool.
 * Copyright (C) 1999, 2000 Peter Todd <retep@penguinpowered.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "common.h"
#include <limits.h>
#include <ctype.h>
#include <sys/types.h> /* for fchmod call in mktmpfile */
#include <sys/stat.h>
#include <unistd.h> /* for access call in mktmp_helper */
#include <fcntl.h>

#ifndef HAVE_STRDUP
char *strdup(const char *s){
  char *r;
  r = malloc(strlen(s) + 1);
  strcpy(r,s);
  return r;
}
#endif

int str2loglevel(char *s){
  char *t;
  int i;

  if (!s){
    fprintf(stderr,"Internal error: NULL s passed to str2loglevel");
    abort();
  }

  t = malloc(strlen(s) + 1);
  for (i = 0; i < strlen(s); i++)
    t[i] = toupper(s[i]);
  t[strlen(s)] = '\000';

#define TESTT(s) ((!strcmp(t,"ESM_LOG_" s)) || (!strcmp(t,"LOG_" s)) || (!strcmp(t,s)))

  if (TESTT("EMERG"))
    return ESM_LOG_EMERG;
  else if (TESTT("EMERGENCY"))
    return ESM_LOG_EMERG;
  else if (TESTT("ALERT"))
    return ESM_LOG_ALERT;
  else if (TESTT("CRIT"))
    return ESM_LOG_CRIT;
  else if (TESTT("CRITICAL"))
    return ESM_LOG_CRIT;
  else if (TESTT("ERR"))
    return ESM_LOG_ERR;
  else if (TESTT("ERROR"))
    return ESM_LOG_ERR;
  else if (TESTT("WARNING"))
    return ESM_LOG_WARNING;
  else if (TESTT("NOTICE"))
    return ESM_LOG_NOTICE;
  else if (TESTT("INFO"))
    return ESM_LOG_INFO;
  else if (TESTT("DEBUG"))
    return ESM_LOG_DEBUG;

  if ((atoi(t) >= 1) && (atoi(t) <= 9))
    return atoi(t);
  return -1;
#undef TESTT
}

int strtime2sec(char *s){
  int i,a;

  a = atoi(s);
  if (strchr(s,'m') != NULL){
    if (a < (INT_MAX / 60)) 
      i = a * 60;
    else
      return INT_MIN;
    }
  else if (strchr(s,'h') != NULL){
    if (a < (INT_MAX / 3600))
        i = a * 3600;
    else
      return INT_MIN;
  }
  else if (strchr(s,'d') != NULL){
    if (a < (INT_MAX / 86400))
        i = a * 86400;
    else
      return INT_MIN;
  }
  else
        i = a;

  return i;                                     
}

int mktmp_helper_i = 0;
void mktmp_helper(char *name){
  char tmpstr[7];
  while (!access(name,F_OK)){
    mktmp_helper_i++;
    if (mktmp_helper_i > 999999)
      mktmp_helper_i = 0;
    snprintf(tmpstr,6,"%d",mktmp_helper_i);
    snprintf(name + (strlen(name) - strlen(tmpstr)),strlen(tmpstr) + 1,"%s",tmpstr);
  }
  /* access sets errno, set it back as there really wasn't an
     error. */
  errno = 0;
}

FILE *mktmpfile(char **name){
  int fd,i;
  FILE *r;
  char *template; 
  
  if (getenv("TMPDIR")){
    template = malloc(strlen(getenv("TMPDIR")) + strlen("/esm000000") + 1);
    strcpy(template,getenv("TMPDIR"));
    strcat(template,"/esm000000");
  }
  else{
    template = malloc(strlen("/tmp/esm000000") + 1);
    strcpy(template,"/tmp/esm000000");
  }

  i = 0;
  fd = -1;
  while ((fd == -1) && (i < 1024)){
    i++;
    mktmp_helper(template);
    fd = open(template,O_CREAT | O_EXCL | O_RDWR,S_IRUSR | S_IWUSR);
  }

  /* Couldn't create tmp file. Return NULL. */
  if (i >= 1024){
    if (name)
      *name = NULL;
    free(template);
    return NULL;
  }

  r = fdopen(fd,"r+");

  if (name)
    *name = template;

  return r;
}

int mktmpfifo(char **name){
  int i;
  char *template; 
  dev_t junkdev_t;

  if (getenv("TMPDIR")){
    template = malloc(strlen(getenv("TMPDIR")) + strlen("/esm000000") + 1);
    strcpy(template,getenv("TMPDIR"));
    strcat(template,"/esm000000");
  }
  else{
    template = malloc(strlen("/tmp/esm000000") + 1);
    strcpy(template,"/tmp/esm000000");
  }

  i = 0;
  while (i < 1024){
    i++;
    mktmp_helper(template);
    if (!mknod(template,S_IRUSR | S_IWUSR | S_IFIFO,junkdev_t))
	break;
  }

  /* Couldn't create tmp file. Return -1. */
  if (i >= 1024){
    if (name)
      *name = NULL;
    free(template);
    return -1;
  }

  if (name)
    *name = template;
  return 0;
}

static char *id="@(#) $Id: common.c,v 1.4 2000/04/27 22:42:25 pete Exp $";
