#include <stdio.h>
#include <stdlib.h>

/* Thomas Haukland, tompi@bigfoot.com, 18. Sep. 1998 */
/* Color-replacement for Linux "mem" and "df" */
/* Tested on kernel 2.0.35 only... */

#define BLACK 0
#define RED 1
#define GREEN 2
#define BROWN 3
#define BLUE 4
#define PURPLE 5
#define CYAN 6
#define GREY 7

#define BAR_LENGTH 50
#define BOLD 2
#define INVERSE 1
#define NORMAL 0

void color_printf(int color, int inv, char string[])
{
		if ( inv == INVERSE ) printf("%s%d%s%s", "\033[30;4", color, "m", string); 
		else if ( inv == BOLD ) printf("%s%d%s%s", "\033[3", color, ";40;1m", string); 
		else printf("%s%d%s%-15s", "\033[3", color, ";40m", string); 
		printf("\033[m");
}

void color_printf_int(int color, int inv, int number)
{
		if ( inv == INVERSE ) printf("%s%d%s%d", "\033[30;4", color, "m", number); 
		else if ( inv == BOLD ) printf("%s%d%s%d", "\033[3", color, ";40;1m", number); 
		else printf("%s%d%s%d", "\033[3", color, ";40m", number); 
		printf("\033[m");
}

void color_print_summary(int i, int j, char string[])
{
	printf(" ");
	color_printf_int(BROWN, BOLD, i);
	if ( j != 0 )
	{
		color_printf(CYAN, BOLD, "/");
		color_printf_int(CYAN, NORMAL, j);
	}
	color_printf(CYAN, BOLD, string);
	printf("\n");
}

void bar_printf(int color_used, int color_free, int used, int total)
{
	int medium,i;
	if ( total == 0 ) total=1;
	medium = ( used * BAR_LENGTH ) / total;
	for (i=1; i<BAR_LENGTH; i++)
	{
		if ( i < medium ) color_printf(color_used, INVERSE, " ");
		else color_printf(color_free, INVERSE, " ");
	}
}
