#!/bin/bash
#
# Write memory- and disk-status with some nice color-graphs :) 
# To get stats, the file "/proc/meminfo" and the commands "df" 
# and "uptime" are used
# 17 Sep, 1997, Tompi ( Thomas Haukland, s770@ii.uib.no )
#####################################################################

#################################################################
# First set which colors to use, and how long the graphs will be:
#################################################################

l=30;				# Graphs will be $l chars long
r_c="\033[m";       		# Reset color-code
u_c="\033[32;41m";  		# Used space will be red
f_c="\033[32;42m";  		# Unused space will be green
s_c="\033[34;44m";  		# Shared, buffers, cached will be blue
w_c="\033[36;40m";  	# Writing will be done with blue
h_c="\033[33;40;1m";		# Highlight with yellow
l1_c="\033[35;40;1m";           # First line(version etc) is bright purple
l2_c="\033[35;40m";            	# Second line(cpu etc) is purple

#######################################################################################
# Output /proc/version and exec 'uptime'
#######################################################################################

echo -en "$l1_c "; cut -f 1 -d \# /proc/version;
echo -en "$r_c$l2_c"; uptime; echo -en "$r_c"

set `cat /proc/meminfo`
#########################################################################
# Now $8 will be total memory, $9 used memory, $11 shared, $15 swap-total 
# $16 swap-used, $12 buffers and $13 cached. Now do some arithmetic:
#########################################################################

u_mem=$[${9} / 1000]; t_mem="/"$[${8} / 1000]; memory=$[${9} * $l / ${8}]; 
u_swap=$[${16} / 1000]; t_swap="/"$[${15} / 1000]; swap=$[${16} * $l / ${15}];
u_shared=$[${11} / 1000]; t_shared=""; shared=$[${11} * $l / ${8}];
u_buffers=$[${12} / 1000]; t_buffers=""; buffers=$[${12} * $l / ${8}];
u_cached=$[${13} / 1000]; t_cached=""; cached=$[${13} * $l / ${8}];

########################################################################
# Declaring a function which will print the mem, swap, buffer, shared
# and cached graphs using these parameters:
# $1: First text-string, $2: Free, $3: Free-color, 
# $4: Used-color, $5: Used-Kb, $6: Total-Kb
########################################################################

function write_graph () {
	echo -en "$w_c $1$4";
	printf "%${2}s" ""; echo -en "$3";
	printf "%$((${l} - ${2}))s" "";
	echo -e "$h_c $5$r_c$w_c$6 Kb used."; 
	}

######################################################
# Write memory, swap, shared, buffer and cache-graphs:

write_graph 	"Memory        : " "$memory" "$f_c" "$u_c" \
		"$u_mem" "$t_mem";
write_graph 	"Swap          : " "$swap" "$f_c" "$u_c" \
		"$u_swap" "$t_swap";
write_graph 	"Shared        : " "$shared" "$r_c" "$s_c" \
		"$u_shared" "$t_shared";
write_graph 	"Buffers       : " "$buffers" "$r_c" "$s_c" \
		"$u_buffers" "$t_buffers";
write_graph 	"Cached        : " "$cached" "$r_c" "$s_c" \
		"$u_cached" "$t_cached";


#############################################################
# Piping "df" through a little awk-program that writes graphs
#############################################################

df | gawk -v r="$r_c" -v w="$w_c" -v h="$h_c" -v f="$f_c" \
          -v u="$u_c" -v s="$s_c" -v lngth="$l" \
	\
	'BEGIN {getline;r_c=r;w_c=w;h_c=h;
	        f_c=f;u_c=u;s_c=s;l=lngth;}
	{
	tot=$3*l/$2+1; 
	printf("%s%s%-14s%s", w_c, " ", $6, ": ");
	
	for (i=1; i<l+1; i++) {
		if ( i < tot ) { printf("%s%s", u_c, " ") }
		else { printf("%s%s", f_c, " ") }
		}
	print(w_c h_c" " $4 r_c w_c"/"$2" Kb free");
	}
	END{printf(r_c)}'
