#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/vfs.h>
#include "color.h"

/* Thomas Haukland, tompi@bigfoot.com, 18. Sep. 1998 */
/* Color-replacement for Linux "mem" and "df" */
/* Tested on kernel 2.0.35 only... */

int main(void)
{
	struct statfs sbuf;
	FILE * meminfo;
	FILE * fsinfo;
	int i,j;
	int memtotal, memfree, memshared, membuffers, cached, swaptotal, swapfree;
	char line[80];
	char filesystem[80];
	char dummy[30];

/* First the memory stats */
/* Open file /proc/meminfo, simple check */

	meminfo = fopen("/proc/meminfo", "r");
	if ( meminfo == ( FILE * ) NULL )
	{
		fprintf(stderr, "%s\n", "Can't open /proc/meminfo ...");
		exit(EXIT_FAILURE);
	}

/* Read file /proc/meminfo */

	while ( fscanf(meminfo, "%s", line) != (int) EOF ) 
	{
		if (!strcmp(line, "MemTotal:" ))  j=fscanf(meminfo, "%i", &memtotal);
		else if (!strcmp(line, "MemFree:" ))  j=fscanf(meminfo, "%i", &memfree);
		else if (!strcmp(line, "MemShared:" ))  j=fscanf(meminfo, "%i", &memshared);
		else if (!strcmp(line, "Buffers:" ))  j=fscanf(meminfo, "%i", &membuffers);
		else if (!strcmp(line, "Cached:" ))  j=fscanf(meminfo, "%i", &cached);
		else if (!strcmp(line, "SwapTotal:" ))  j=fscanf(meminfo, "%i", &swaptotal);
		else if (!strcmp(line, "SwapFree:" ))  j=fscanf(meminfo, "%i", &swapfree);
		if ( j == EOF ) 
		{
			fprintf(stderr, "%s\n", "Error during reading of file...");
			exit(EXIT_FAILURE);
		}
	}

	fclose(meminfo);

/* Print out the nice graphs... */ 

	color_printf(CYAN, NORMAL, "Memory:   ");
	bar_printf(RED, GREEN, memtotal-memfree, memtotal);
	color_print_summary(memtotal-memfree, memtotal, " Used.");

	color_printf(CYAN, NORMAL, "Swap:     ");
	bar_printf(RED, GREEN, swaptotal-swapfree, swaptotal);
	color_print_summary(swaptotal-swapfree, swaptotal, " Used.");

	color_printf(CYAN, NORMAL, "Shared:   ");
	bar_printf(BLUE, BLACK, memshared, memtotal);
	color_print_summary(memshared, 0, " Used.");

	color_printf(CYAN, NORMAL, "Buffers:  ");
	bar_printf(BLUE, BLACK, membuffers, memtotal);
	color_print_summary(membuffers, 0, " Used.");

	color_printf(CYAN, NORMAL, "Cached:   ");
	bar_printf(BLUE, BLACK, cached, memtotal);
	color_print_summary(cached, 0, " Used.");

/* Now for the filesystems... */
/* First open /proc/mounts    */


	fsinfo = fopen("/proc/mounts", "r");
	if ( fsinfo == ( FILE * ) NULL )
	{
		fprintf(stderr, "%s\n", "Can't open /proc/mounts ...");
		exit(EXIT_FAILURE);
	}

/* Read file /proc/meminfo, get info from statfs and print graphs */

	while ( fscanf(fsinfo, "%s%s%s%s%s%s", dummy, filesystem, dummy, dummy, \
	        dummy, dummy) != (int) EOF ) 
	{
	   if (strcmp(filesystem, "/proc"))
	   {
		if ( statfs(filesystem, &sbuf) == 0 ) 
			{
			color_printf(CYAN, NORMAL, filesystem);
			bar_printf(RED, GREEN, sbuf.f_blocks-sbuf.f_bfree, sbuf.f_blocks);
			color_print_summary(sbuf.f_bfree, sbuf.f_blocks, " Free.");
			}
		else 
			{
			fprintf(stderr, "%s%s\n", "Hmm. Can't get info on ", filesystem);
			exit(EXIT_FAILURE);
			}
	   }
	}

	fclose(fsinfo);
	
	exit(EXIT_SUCCESS);
}
