/*  <PROJECT NAME>
 *  Copyright (C) <YEAR> <AUTHORS>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>    
#include <glibtop.h>
#include <glibtop/open.h>
#include <glibtop/close.h>

#include <glibtop/cpu.h>                                                     
#include "sig.h"


     GdkPixmap  *fg_pixmap;
     GtkWidget  *window;
     GdkPixmap  *bg_pixmap;
     GdkGC      *gc; 
     static int ptimer = 0; 
     guint32    update_time;
     char       dummy[10];
     float      oldcpuread[4];
     float      cpuread[4];
     float      cpudiaf[4];
     float      totalload;
     float      cpuvalue;
     int        i;
     glibtop server;
     glibtop_cpu cpu;

static gint button_press (GtkWidget *widget, GdkEvent *event)
{

    if (event->type == GDK_BUTTON_PRESS) {
        GdkEventButton *bevent = (GdkEventButton *) event;
        gtk_menu_popup (GTK_MENU(widget), NULL, NULL, NULL, NULL,
                        bevent->button, bevent->time);
        return TRUE;
    }

    return FALSE;
}


/* This Function reads the starting values for calibration */

     void firstvalues()
     {

      for ( i = 0 ; i < 4 ; i++ ){
         oldcpuread[i] = 0;
         cpuread[i] = 0;
         cpudiaf[i] = 0;
         }

        glibtop_get_cpu_s (&server, &cpu);

        oldcpuread[0]=cpu.user;
        oldcpuread[1]=cpu.nice;
        oldcpuread[2]=cpu.sys;
        oldcpuread[3]=cpu.idle;
     return ;
     }
/* ---------------------------------------------------------------------------*/

     /* This function increments and updates the progress bar */

     gint progress (gpointer data)
     {
        int number;

        totalload = 0;


        glibtop_get_cpu_s (&server, &cpu);

        cpuread[0]=cpu.user;
        cpuread[1]=cpu.nice;
        cpuread[2]=cpu.sys;
        cpuread[3]=cpu.idle;


        glibtop_close ();   
       for ( i = 0 ; i < 4 ; i++ ){
             cpudiaf[i] = cpuread[i] - oldcpuread[i];
             totalload += cpudiaf[i];
             }

         if (totalload){
         cpuvalue =  ((totalload - cpudiaf[3]) / totalload) ;
          for (i = 0 ; i < 4 ; i++ ){
          oldcpuread[i] = cpuread[i];
          }
          totalload = 0;
         }



     number =(int)(cpuvalue*100)/5;
     if(number>20)
            number = 20;

    gdk_draw_pixmap(window->window, gc, fg_pixmap, 0, 0, 104, 39, number*7, 17);
    gdk_draw_pixmap(window->window, gc, bg_pixmap, 0, 0, 104+number*7, 39, 141-number*7, 17);
     return TRUE;
     }
/* -------------------------------------------------------------------------- */


void menuitem2_response ()
{
  gtk_main_quit(); 
}                   
 
void
on_entry_update_time_changed                      (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(user_data));
  update_time = atoi(entry_text);
}

void
on_button_ok_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_timeout_remove(ptimer);
  ptimer = gtk_timeout_add (update_time, progress, NULL);      
  gtk_widget_destroy(user_data);
}            


GtkWidget*
create_dialog_update ()
{
  GtkWidget *dialog_update;
  GtkWidget *dialog_vbox1;
  GtkWidget *entry_update_time;
  GtkWidget *dialog_action_area1;                                                 GtkWidget *button_ok;

  dialog_update = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (dialog_update), "dialog_update", dialog_update);
  gtk_window_set_title (GTK_WINDOW (dialog_update), "Update Time");
  gtk_window_set_policy (GTK_WINDOW (dialog_update), TRUE, TRUE, FALSE);

  dialog_vbox1 = GTK_DIALOG (dialog_update)->vbox;
  gtk_object_set_data (GTK_OBJECT (dialog_update), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  entry_update_time = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (dialog_update), "entry_update_time", entry_update_time);
  gtk_widget_show (entry_update_time);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), entry_update_time, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (entry_update_time), "changed",
                      GTK_SIGNAL_FUNC (on_entry_update_time_changed),
                      GTK_OBJECT(entry_update_time));

  dialog_action_area1 = GTK_DIALOG (dialog_update)->action_area;
  gtk_object_set_data (GTK_OBJECT (dialog_update), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  button_ok = gtk_button_new_with_label ("OK");
  gtk_object_set_data (GTK_OBJECT (dialog_update), "button_ok", button_ok);
  gtk_widget_show (button_ok);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), button_ok, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (button_ok), "clicked",
                      GTK_SIGNAL_FUNC (on_button_ok_clicked),
                      GTK_OBJECT(dialog_update));

  return dialog_update;
}

void menuitem1_response ()
{
GtkWidget *dialog_update;
dialog_update = create_dialog_update ();
gtk_widget_show (dialog_update);   
}                   


GtkWidget*
create_window ()
{
  GtkWidget *hbox1, *fixed, *button_quit;
  GtkWidget *menu, *menu_item1, *menu_item2;
  GtkWidget *vbox1;
  GdkPixmap *pixmap_light;
  GdkPixmap *pixmap_cpu;
  GdkBitmap *mask;           
  GtkStyle  *style; 

  update_time = 200;
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (window, "main window");
  gtk_object_set_data (GTK_OBJECT (window), "window", window);
  gtk_widget_set_usize (window, 273, 94);
  gtk_window_set_title (GTK_WINDOW (window), "Cpu Pulse");
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
  gtk_widget_show (window);

  gc = gdk_gc_new(window->window); 
  style = gtk_widget_get_default_style(); 

  bg_pixmap = gdk_pixmap_create_from_xpm_d( window->window,  &mask,
                                        &style->bg[GTK_STATE_NORMAL],
                                        (gchar **)darkbar_xpm );
  gdk_draw_pixmap(window->window, gc, bg_pixmap, 0, 0, 104, 39, 141, 17);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window), "hbox1", hbox1);
  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (window), hbox1); 

  fixed = gtk_fixed_new ();
  gtk_object_set_data (GTK_OBJECT (window), "fixed", fixed);
  gtk_widget_show (fixed);
  gtk_box_pack_start (GTK_BOX (hbox1), fixed, FALSE, FALSE, 0);
  gtk_widget_set_usize (fixed, 84, 85);

  menu = gtk_menu_new();
  menu_item1 = gtk_menu_item_new_with_label("Change Update Time");
  gtk_menu_append(GTK_MENU (menu), menu_item1);
  menu_item2 = gtk_menu_item_new_with_label("Exit");
  gtk_menu_append(GTK_MENU (menu), menu_item2);
  gtk_signal_connect_object(GTK_OBJECT(menu_item1), "activate",
                     GTK_SIGNAL_FUNC(menuitem1_response), NULL);
  gtk_signal_connect_object(GTK_OBJECT(menu_item2), "activate",
                     GTK_SIGNAL_FUNC(menuitem2_response), NULL);
  gtk_widget_show(menu_item1);
  gtk_widget_show(menu_item2);

  button_quit = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (window), "button_quit", button_quit);
  gtk_widget_show (button_quit);
  gtk_fixed_put (GTK_FIXED (fixed), button_quit, 15, 14);   
  gtk_widget_set_usize (button_quit, 64, 65);
  gtk_signal_connect_object(GTK_OBJECT(button_quit), "event",
  GTK_SIGNAL_FUNC (button_press), GTK_OBJECT(menu));

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window), "vbox1", vbox1);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox1, TRUE, TRUE, 0);


  fg_pixmap = gdk_pixmap_create_from_xpm_d( window->window,  &mask,
                                        &style->bg[GTK_STATE_NORMAL],
                                        (gchar **)lightbar_xpm );

  ptimer = gtk_timeout_add (update_time, progress, NULL);      
  return window;
}
