/*
 *  Copyright (C) <1998> <mdigas@freemail.gr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "sig.h"

#define RCFILE "/usr/local/gpulse/gpulserc"

int main (int argc, char *argv[])
{
	GtkWidget *window;
	char *rcfile = RCFILE;
	FILE *rc_file=fopen(rcfile, "r");

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	/*
	 * The following code was added by Glade to create one of each component,
	 * just so that you see something after building the project.
	 * Delete any components that you don't want shown initially.
	 */

	if (rc_file == NULL)
	{
		char *home=getenv("HOME");
		if(home==NULL)
			home=".";
		rcfile = strcat(home, "/.gpulse/gpulserc");
		rc_file = fopen(rcfile, "r");
	}
	if ( !rc_file )
	{
		fprintf(stderr, "Can't open file: " RCFILE " or %s.\n", rcfile);
		exit( 1 );
        }       

	gtk_rc_parse(rcfile);
	window = create_window ();
	gtk_widget_show (window);
	gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                      GTK_SIGNAL_FUNC (gtk_main_quit), NULL);


	gtk_main ();
	return 0;
}

