/*  webble - generic launcher
    Copyright (C) 1998  Rubens Ramos Fernandes Junior

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __TKN_H__

#include <malloc.h>
#include <errno.h>
#include <g++/iostream.h>
#include <unistd.h>
#include <ncurses.h>
#include <form.h>
#include <menu.h>

#define NOK ERR

#define TKN_B 500
#define TKN_IDENT 501
#define TKN_TTEXT 502
#define TKN_EXECUTABLE 503
#define TKN_PARAMETERS 504
#define TKN_DESCRIPTION 505
#define TKN_OBJECT 506
#define TKN_E 507
#define TKN_FILTER 508

// CLASSES FORWARD DEFINITIONS ------------------

class   tkn;
typedef tkn* p_tkn;

class   card;
typedef card* p_crd;

class   exec;
typedef exec* p_exe;

// EXTERN VARS DEFINITIONS ---------------
extern p_tkn cards;

// TKN CLASS DEFINITION ------------------

class tkn {
private:
  char  *text;
  int   type;

public:
  p_tkn next;

  tkn  (char *txt, int typ);
  ~tkn (void);

  int  get_type (void);
  char *get_text (void);
};


// CARD CLASS DEFINITION ------------------

class card {
private:
  p_tkn tokens;

public:
  p_crd next;

  card  (p_tkn toks);
  ~card (void);

  char *get_text(int type);
};


// EXEC CLASS DEFINITION ------------------

class exec {
private:
  int   ncards,curr_pos;
  p_crd cards,curr_card;

public:
  exec  (p_crd crds);
  ~exec (void);

  int set_card(int pos);
  int get_card(void);
  int next_card(void);
  int num_cards(void);
  char *read_token (int type);

};

#define __TKN_H__
#endif
