/*  webble - generic launcher
    Copyright (C) 1998  Rubens Ramos Fernandes Junior

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "tkn.hxx"

// TKN CLASS IMPLEMENTATION ------------------

tkn::tkn (char *txt, int typ)
{
  if (txt[strlen(txt)-1]=='\n')
    txt[strlen(txt)-1]='\0';
  text = txt;
  type = typ;
  next = NULL;
}

tkn::~tkn (void)
{
  free ((char *)text);
}

int tkn::get_type(void)
{
  return type;
}

char *tkn::get_text(void)
{
  return text;
}


// CARD CLASS IMPLEMENTATION ------------------

card::card (p_tkn toks)
{
  tokens = toks;
  next = NULL;

}

card::~card (void)
{
  p_tkn aux, aux2 = tokens;

  do {
    aux = aux2;
    aux2 = aux2->next;
    delete aux;
  } while (aux2 != NULL);

}

char *card::get_text(int type)
{
  p_tkn aux = tokens;

  while (aux!=NULL && aux->get_type()!=type)
    aux=aux->next;

  if (aux==NULL) return NULL;

  return aux->get_text();
}

// EXEC CLASS IMPLEMENTATION ------------------

exec::exec (p_crd crds)
{
  p_crd temp=crds;

  ncards = 0;
  curr_pos = 1;
  cards = curr_card = crds;

  do{
    ncards++;
  } while ((temp=temp->next));
  return;
  
}

exec::~exec (void)
{
  delete cards;
  return;
}

int exec::set_card(int pos)
{
  int i;

  if (pos>ncards)
    return NOK;

  for (i=0,curr_card=cards; i<pos; i++)
    curr_card = curr_card->next;

  curr_pos = pos;
  return OK;
}


int exec::get_card(void)
{
  return curr_pos;
}


int exec::next_card(void)
{
  if (curr_card!=NULL) {
    curr_card=curr_card->next;
    curr_pos++;
    return OK;
  } else {
    return NOK;
  }
}

char *exec::read_token (int type)
{
  return curr_card->get_text(type);
}

int exec::num_cards(void)
{
  return ncards;
}


